/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EG_WF_STATES")
@SequenceGenerator(name="SEQ_EG_WF_STATES", sequenceName="SEQ_EG_WF_STATES", allocationSize=1)
public class State
extends AbstractAuditable {
    public static final String DEFAULT_STATE_VALUE_CREATED = "Created";
    public static final String DEFAULT_STATE_VALUE_CLOSED = "Closed";
    public static final String STATE_REOPENED = "Reopened";
    protected static final String SEQ_STATE = "SEQ_EG_WF_STATES";
    private static final long serialVersionUID = -9159043292636575746L;
    @Id
    @GeneratedValue(generator="SEQ_EG_WF_STATES", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    private String type;
    @NotNull
    @Length(min=1)
    private String value;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER_POS")
    private Position ownerPosition;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER_USER")
    private User ownerUser;
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.LAZY, mappedBy="state")
    @OrderBy(value="id")
    private Set<StateHistory> history = new HashSet<StateHistory>();
    private String senderName;
    private String nextAction;
    private String comments;
    private String natureOfTask;
    private String extraInfo;
    private Date dateInfo;
    private Date extraDateInfo;
    @Enumerated(value=EnumType.ORDINAL)
    @NotNull
    private StateStatus status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="INITIATOR_POS")
    private Position initiatorPosition;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="previousOwner")
    private Position previousOwner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="previousStateRef")
    private State previousStateRef;

    protected State() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    protected void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    protected void setValue(String value) {
        this.value = value;
    }

    public Position getOwnerPosition() {
        return this.ownerPosition;
    }

    protected void setOwnerPosition(Position ownerPosition) {
        this.ownerPosition = ownerPosition;
    }

    public User getOwnerUser() {
        return this.ownerUser;
    }

    protected void setOwnerUser(User ownerUser) {
        this.ownerUser = ownerUser;
    }

    public Set<StateHistory> getHistory() {
        return this.history;
    }

    protected void setHistory(Set<StateHistory> history) {
        this.history = history;
    }

    protected void addStateHistory(StateHistory history) {
        this.getHistory().add(history);
    }

    public String getSenderName() {
        return this.senderName;
    }

    protected void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getNextAction() {
        return this.nextAction;
    }

    protected void setNextAction(String nextAction) {
        this.nextAction = nextAction;
    }

    public String getComments() {
        return this.comments;
    }

    protected void setComments(String comments) {
        this.comments = comments;
    }

    public String getNatureOfTask() {
        return this.natureOfTask;
    }

    public void setNatureOfTask(String natureOfTask) {
        this.natureOfTask = natureOfTask;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    protected void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Date getDateInfo() {
        return this.dateInfo;
    }

    protected void setDateInfo(Date dateInfo) {
        this.dateInfo = dateInfo;
    }

    public Date getExtraDateInfo() {
        return this.extraDateInfo;
    }

    protected void setExtraDateInfo(Date extraDateInfo) {
        this.extraDateInfo = extraDateInfo;
    }

    protected StateStatus getStatus() {
        return this.status;
    }

    protected void setStatus(StateStatus status) {
        this.status = status;
    }

    @Override
    public boolean isNew() {
        return this.status.equals((Object)StateStatus.STARTED);
    }

    public boolean isEnded() {
        return this.status.equals((Object)StateStatus.ENDED);
    }

    public boolean isInprogress() {
        return this.status.equals((Object)StateStatus.INPROGRESS);
    }

    public Position getInitiatorPosition() {
        return this.initiatorPosition;
    }

    public void setInitiatorPosition(Position initiatorPosition) {
        this.initiatorPosition = initiatorPosition;
    }

    public Position getPreviousOwner() {
        return this.previousOwner;
    }

    public void setPreviousOwner(Position previousOwner) {
        this.previousOwner = previousOwner;
    }

    public State getPreviousStateRef() {
        return this.previousStateRef;
    }

    public void setPreviousStateRef(State previousStateRef) {
        this.previousStateRef = previousStateRef;
    }

    public static enum StateStatus {
        STARTED,
        INPROGRESS,
        ENDED;

    }
}

