/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.support.propertyeditor;

import java.beans.PropertyEditorSupport;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class JodaDateTimeEditor
extends PropertyEditorSupport {
    private final boolean allowEmpty;
    private final String datePattern;

    public JodaDateTimeEditor(String datePattern, boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        this.datePattern = datePattern;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && StringUtils.isBlank((CharSequence)text)) {
            this.setValue(null);
        } else {
            this.setValue(DateTimeFormat.forPattern((String)this.datePattern).parseDateTime(text));
        }
    }

    @Override
    public String getAsText() {
        DateTime value = (DateTime)this.getValue();
        return value == null ? "" : DateTimeFormat.forPattern((String)this.datePattern).print((ReadableInstant)value);
    }
}

