/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils;

import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import net.tanesha.recaptcha.ReCaptchaImpl;
import net.tanesha.recaptcha.ReCaptchaResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.egov.infra.config.properties.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecaptchaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RecaptchaUtils.class);
    private static final String RECAPTCHA_VERIFY_URL = "https://www.google.com/recaptcha/api/siteverify";
    @Autowired
    private ApplicationProperties applicationProperties;

    public boolean captchaIsValid(HttpServletRequest request) {
        try {
            if ("high".equals(this.applicationProperties.getProperty("captcha.strength"))) {
                HttpPost post = new HttpPost(RECAPTCHA_VERIFY_URL);
                ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                urlParameters.add(new BasicNameValuePair("secret", (String)request.getSession().getAttribute("siteSecret")));
                urlParameters.add(new BasicNameValuePair("response", request.getParameter("g-recaptcha-response")));
                urlParameters.add(new BasicNameValuePair("remoteip", request.getRemoteAddr()));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
                String responseJson = IOUtils.toString((InputStream)HttpClientBuilder.create().build().execute((HttpUriRequest)post).getEntity().getContent(), (Charset)Charset.defaultCharset());
                return Boolean.valueOf(((HashMap)new GsonBuilder().create().fromJson(responseJson, HashMap.class)).get("success").toString());
            }
            String remoteAddr = request.getRemoteAddr();
            ReCaptchaImpl reCaptcha = new ReCaptchaImpl();
            reCaptcha.setPrivateKey((String)request.getSession().getAttribute("siteSecret"));
            String challenge = request.getParameter("recaptcha_challenge_field");
            String uresponse = request.getParameter("recaptcha_response_field");
            ReCaptchaResponse reCaptchaResponse = reCaptcha.checkAnswer(remoteAddr, challenge, uresponse);
            return reCaptchaResponse.isValid();
        }
        catch (Exception e) {
            LOG.error("Recaptcha verification failed", (Throwable)e);
            return false;
        }
    }
}

