/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.authentication;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class AuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private Map<String, String> roleTargetUrlMapping = new HashMap<String, String>();

    protected void handle(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        String targetUrl = this.determineTargetUrl(authentication);
        if (response.isCommitted()) {
            this.logger.debug((Object)("Response has already been committed. Unable to redirect to " + targetUrl));
            return;
        }
        this.redirectStrategy.sendRedirect(request, response, targetUrl);
    }

    public String determineTargetUrl(Authentication authentication) {
        Collection authorities = authentication.getAuthorities();
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!this.roleTargetUrlMapping.containsKey(grantedAuthority.getAuthority())) continue;
            return this.roleTargetUrlMapping.get(grantedAuthority.getAuthority());
        }
        throw new IllegalStateException("Insufficient Role");
    }

    public RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public void setRoleTargetUrlMapping(Map<String, String> roleTargetUrlMapping) {
        this.roleTargetUrlMapping = roleTargetUrlMapping;
    }
}

