/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.engine;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.util.ReportUtil;

public class ReportRequest {
    private static final Properties REPORT_CONFIG = ReportUtil.loadReportConfig();
    private ReportDataSourceType reportDataSourceType;
    private String reportTemplate;
    private String reportName;
    private ReportFormat reportFormat;
    private Object reportInputData;
    private Map<String, Object> reportParams = new HashMap<String, Object>();
    private boolean printDialogOnOpenReport = false;

    public ReportRequest(String reportTemplate, Object reportInputData, Map<String, Object> reportParams) {
        this.initialize(reportTemplate, reportParams);
        this.reportInputData = reportInputData;
        this.reportDataSourceType = ReportDataSourceType.JAVABEAN;
    }

    public ReportRequest(String reportTemplate, Map<String, Object> reportParams, ReportDataSourceType dataSourceType) {
        this.initialize(reportTemplate, reportParams);
        this.reportDataSourceType = dataSourceType;
    }

    public ReportRequest(String reportTemplate, Object[] reportInputData, Map<String, Object> reportParams) {
        this(reportTemplate, (Object)reportInputData, reportParams);
    }

    public ReportRequest(String reportTemplate, Collection reportInputData, Map<String, Object> reportParams) {
        this(reportTemplate, (Object)reportInputData, reportParams);
    }

    private void initialize(String reportTemplate, Map<String, Object> reportParams) {
        this.reportTemplate = reportTemplate;
        this.reportParams = reportParams;
        this.reportFormat = REPORT_CONFIG == null ? ReportFormat.PDF : ReportFormat.valueOf(REPORT_CONFIG.getProperty(this.reportTemplate, ReportFormat.PDF.name()));
    }

    public String getReportTemplate() {
        return this.reportTemplate;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportFormat reportFormat) {
        this.reportFormat = reportFormat;
    }

    public Map<String, Object> getReportParams() {
        return this.reportParams;
    }

    public void setReportParams(Map<String, Object> reportParams) {
        this.reportParams = reportParams;
    }

    public Object getReportInputData() {
        return this.reportInputData;
    }

    public ReportDataSourceType getReportDataSourceType() {
        return this.reportDataSourceType;
    }

    public boolean isPrintDialogOnOpenReport() {
        return this.printDialogOnOpenReport;
    }

    public void setPrintDialogOnOpenReport(boolean printDialogOnOpenReport) {
        this.printDialogOnOpenReport = printDialogOnOpenReport;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String reportOutputFileName() {
        return this.reportName + "." + (Object)((Object)this.reportFormat);
    }
}

