/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.entity.component;

import java.io.Serializable;
import java.text.DecimalFormat;
import javax.validation.constraints.Min;

public class Money
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Min(value=0L, message="non.negative")
    private double value;

    private Money() {
    }

    public Money(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Money add(Money money) {
        return new Money(this.value + money.getValue());
    }

    public Money addAll(Money ... monies) {
        double v = this.value;
        for (Money m : monies) {
            v += m.value;
        }
        return new Money(v);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Money other = (Money)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public String getFormattedString() {
        double rounded = (double)Math.round(this.value * 100.0) / 100.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        formatter.setDecimalSeparatorAlwaysShown(true);
        return formatter.format(rounded);
    }
}

