/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.messaging.sms;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.egov.infra.config.core.GlobalSettings;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.messaging.MessagePriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SMSService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMSService.class);
    private static final String SMS_PRIORITY_PARAM_VALUE = "sms.%s.priority.param.value";
    private static final String SENDERID_PARAM_NAME = "sms.sender.req.param.name";
    private static final String USERNAME_PARAM_NAME = "sms.sender.username.req.param.name";
    private static final String PASWRD_PARAM_NAME = "sms.sender.password.req.param.name";
    private static final String DEST_MOBILENUM_PARAM_NAME = "sms.destination.mobile.req.param.name";
    private static final String DEST_MESSAGE_PARAM_NAME = "sms.message.req.param.name";
    private static final String SMS_EXTRA_REQ_PARAMS = "sms.extra.req.params";
    private static final String SMS_PRIORITY_PARAM_NAME = "sms.priority.param.name";
    @Autowired
    private ApplicationProperties applicationProperties;

    public boolean sendSMS(String mobileNumber, String message) {
        return this.sendSMS(mobileNumber, message, MessagePriority.MEDIUM);
    }

    public boolean sendSMS(String mobileNumber, String message, MessagePriority priority) {
        if (this.applicationProperties.smsEnabled()) {
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost post = new HttpPost(this.applicationProperties.smsProviderURL());
                ArrayList<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.applicationProperties.getProperty(USERNAME_PARAM_NAME), this.applicationProperties.smsSenderUsername()));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.applicationProperties.getProperty(PASWRD_PARAM_NAME), this.applicationProperties.smsSenderPassword()));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.applicationProperties.getProperty(SENDERID_PARAM_NAME), this.applicationProperties.smsSender()));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.applicationProperties.getProperty(DEST_MOBILENUM_PARAM_NAME), GlobalSettings.countryCode() + mobileNumber));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.applicationProperties.getProperty(DEST_MESSAGE_PARAM_NAME), message));
                this.setAdditionalParameters(urlParameters, priority);
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters, GlobalSettings.defaultEncoding()));
                HttpResponse response = client.execute((HttpUriRequest)post);
                String responseCode = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)GlobalSettings.defaultEncoding());
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("SMS sending completed with response code [{}] - [{}]", (Object)responseCode, (Object)this.applicationProperties.smsResponseMessageForCode(responseCode));
                }
                return this.applicationProperties.smsErrorCodes().parallelStream().noneMatch(responseCode::startsWith);
            }
            catch (IOException | UnsupportedOperationException e) {
                LOGGER.error("Error occurred while sending SMS [%s]", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private void setAdditionalParameters(List<NameValuePair> urlParameters, MessagePriority priority) {
        String[] extraParms;
        if (StringUtils.isNotBlank((CharSequence)this.applicationProperties.getProperty(SMS_EXTRA_REQ_PARAMS)) && (extraParms = this.applicationProperties.getProperty(SMS_EXTRA_REQ_PARAMS).split("&")).length > 0) {
            for (String extraParm : extraParms) {
                String[] paramNameValue = extraParm.split("=");
                urlParameters.add((NameValuePair)new BasicNameValuePair(paramNameValue[0], paramNameValue[1]));
            }
        }
        if (this.applicationProperties.smsPriorityEnabled()) {
            urlParameters.add((NameValuePair)new BasicNameValuePair(this.applicationProperties.getProperty(SMS_PRIORITY_PARAM_NAME), this.applicationProperties.getProperty(String.format(SMS_PRIORITY_PARAM_VALUE, priority.toString()))));
        }
    }
}

