/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.elasticsearch.service;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.repository.ApplicationIndexRepository;
import org.egov.infra.elasticsearch.service.es.ApplicationDocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ApplicationIndexService {
    private final ApplicationIndexRepository applicationIndexRepository;
    private final ApplicationDocumentService applicationDocumentService;
    @Autowired
    private CityService cityService;

    @Autowired
    public ApplicationIndexService(ApplicationIndexRepository applicationIndexRepository, ApplicationDocumentService applicationDocumentService) {
        this.applicationIndexRepository = applicationIndexRepository;
        this.applicationDocumentService = applicationDocumentService;
    }

    @Transactional
    public ApplicationIndex createApplicationIndex(ApplicationIndex applicationIndex) {
        Map<String, Object> cityInfo = this.cityService.cityDataAsMap();
        applicationIndex.setCityCode(StringUtils.defaultString((String)((String)cityInfo.get("cityCode"))));
        applicationIndex.setCityName(StringUtils.defaultString((String)((String)cityInfo.get("cityname"))));
        applicationIndex.setCityGrade(StringUtils.defaultString((String)((String)cityInfo.get("cityGrade"))));
        applicationIndex.setDistrictName(StringUtils.defaultString((String)((String)cityInfo.get("districtName"))));
        applicationIndex.setRegionName(StringUtils.defaultString((String)((String)cityInfo.get("cityRegion"))));
        this.applicationIndexRepository.save(applicationIndex);
        this.applicationDocumentService.createOrUpdateApplicationDocument(applicationIndex);
        return applicationIndex;
    }

    @Transactional
    public ApplicationIndex updateApplicationIndex(ApplicationIndex applicationIndex) {
        this.applicationIndexRepository.save(applicationIndex);
        this.applicationDocumentService.createOrUpdateApplicationDocument(applicationIndex);
        return applicationIndex;
    }

    public ApplicationIndex findByApplicationNumber(String applicationNumber) {
        return this.applicationIndexRepository.findByApplicationNumberAndCityName(applicationNumber, ApplicationThreadLocals.getCityName());
    }
}

