/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.scheduling;

import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.egov.infra.scheduler.quartz.QuartzJobAwareBeanFactory;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SimpleThreadPoolTaskExecutor;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

public class QuartzSchedulerConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Environment env;

    @Bean
    public SpringBeanJobFactory springBeanJobFactory() {
        QuartzJobAwareBeanFactory jobFactory = new QuartzJobAwareBeanFactory();
        jobFactory.setApplicationContext(this.applicationContext);
        return jobFactory;
    }

    @Bean(destroyMethod="destroy")
    @Scope(value="prototype")
    public SimpleThreadPoolTaskExecutor taskExecutor() {
        SimpleThreadPoolTaskExecutor taskExecutor = new SimpleThreadPoolTaskExecutor();
        taskExecutor.setInstanceId("AUTO");
        taskExecutor.setInstanceName("ERP_APP_SCHEDULER");
        taskExecutor.setThreadCount(10);
        taskExecutor.setThreadNamePrefix("ERP_APP_SCHEDULER");
        taskExecutor.setThreadPriority(5);
        taskExecutor.setThreadsInheritContextClassLoaderOfInitializingThread(true);
        taskExecutor.setThreadsInheritGroupOfInitializingThread(true);
        taskExecutor.setWaitForJobsToCompleteOnShutdown(true);
        return taskExecutor;
    }

    protected SchedulerFactoryBean createScheduler(DataSource dataSource) {
        SchedulerFactoryBean schedulerFactory = new SchedulerFactoryBean();
        schedulerFactory.setOverwriteExistingJobs(true);
        schedulerFactory.setAutoStartup(false);
        schedulerFactory.setExposeSchedulerInRepository(true);
        schedulerFactory.setJobFactory((JobFactory)this.springBeanJobFactory());
        schedulerFactory.setTaskExecutor((Executor)this.taskExecutor());
        schedulerFactory.setWaitForJobsToCompleteOnShutdown(false);
        schedulerFactory.setQuartzProperties(this.quartzProperties());
        schedulerFactory.setDataSource(dataSource);
        return schedulerFactory;
    }

    private Properties quartzProperties() {
        Properties quartzProps = new Properties();
        quartzProps.put("org.quartz.scheduler.instanceId", "AUTO");
        quartzProps.put("org.quartz.scheduler.instanceName", "ERP_APP_SCHEDULER");
        quartzProps.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        quartzProps.put("org.quartz.scheduler.skipUpdateCheck", "true");
        quartzProps.put("org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer", "true");
        quartzProps.put("org.quartz.jobStore.isClustered", this.env.getProperty("scheduler.clustered"));
        quartzProps.put("org.quartz.jobStore.clusterCheckinInterval", "60000");
        quartzProps.put("org.quartz.jobStore.acquireTriggersWithinLock", "false");
        quartzProps.put("org.quartz.jobStore.txIsolationLevelReadCommitted", "true");
        quartzProps.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
        quartzProps.put("org.quartz.jobStore.useProperties", "true");
        quartzProps.put("org.quartz.jobStore.dataSource", "quartzDS");
        quartzProps.put("org.quartz.jobStore.nonManagedTXDataSource", "quartzNoTXDS");
        quartzProps.put("org.quartz.jobStore.tablePrefix", this.env.getProperty("scheduler.default.table.prefix"));
        quartzProps.put("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreCMT");
        quartzProps.put("org.quartz.jobStore.dontSetNonManagedTXConnectionAutoCommitFalse", "false");
        quartzProps.put("org.quartz.jobStore.dontSetAutoCommitFalse", "true");
        quartzProps.put("org.quartz.dataSource.quartzDS.jndiURL", this.env.getProperty("default.jdbc.jndi.datasource"));
        quartzProps.put("org.quartz.dataSource.quartzNoTXDS.jndiURL", this.env.getProperty("scheduler.datasource.jndi.url"));
        quartzProps.put("org.quartz.plugin.jobHistory.class", "org.quartz.plugins.history.LoggingJobHistoryPlugin");
        quartzProps.put("org.quartz.plugin.jobHistory.jobToBeFiredMessage", "Job [{1}.{0}] to be fired by trigger [{4}.{3}], re-fire: {7}");
        quartzProps.put("org.quartz.plugin.jobHistory.jobSuccessMessage", "Job [{1}.{0}] execution complete and reports: {8}");
        quartzProps.put("org.quartz.plugin.jobHistory.jobFailedMessage", "Job [{1}.{0}] execution failed with exception: {8}");
        quartzProps.put("org.quartz.plugin.jobHistory.jobWasVetoedMessage", "Job [{1}.{0}] was vetoed. It was to be fired by trigger [{4}.{3}] at: {2, date, dd-MM-yyyy HH:mm:ss.SSS}");
        quartzProps.put("org.quartz.plugin.triggerHistory.class", "org.quartz.plugins.history.LoggingTriggerHistoryPlugin");
        quartzProps.put("org.quartz.plugin.triggerHistory.triggerFiredMessage", "Trigger [{1}.{0}] fired job [{6}.{5}] scheduled at: {2, date, dd-MM-yyyy HH:mm:ss.SSS}, next scheduled at: {3, date, dd-MM-yyyy HH:mm:ss.SSS}");
        quartzProps.put("org.quartz.plugin.triggerHistory.triggerCompleteMessage", "Trigger [{1}.{0}] completed firing job [{6}.{5}] with resulting trigger instruction code: {9}. Next scheduled at: {3, date, dd-MM-yyyy HH:mm:ss.SSS}");
        quartzProps.put("org.quartz.plugin.triggerHistory.triggerMisfiredMessage", "Trigger [{1}.{0}] misfired job [{6}.{5}]. Should have fired at: {3, date, dd-MM-yyyy HH:mm:ss.SSS}");
        quartzProps.put("org.quartz.plugin.shutdownHook.class", "org.quartz.plugins.management.ShutdownHookPlugin");
        quartzProps.put("org.quartz.plugin.shutdownHook.cleanShutdown", "true");
        return quartzProps;
    }
}

