/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.properties;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;

@Configuration
@PropertySource(value={"classpath:config/application-config.properties", "classpath:config/egov-erp-${user.name}.properties", "classpath:config/application-config-${client.id}.properties", "classpath:config/egov-erp-override.properties"}, ignoreResourceNotFound=true)
public class ApplicationProperties {
    private static final String FILESTORE_BASE_DIR = "filestore.base.dir";
    private static final String FILESTORESERVICE_BEANNAME = "filestoreservice.beanname";
    private static final String MAIL_PORT = "mail.port";
    private static final String MAIL_HOST = "mail.host";
    private static final String MAIL_PROTOCOL = "mail.protocol";
    private static final String MAIL_SENDER_USERNAME = "mail.sender.username";
    private static final String MAIL_SENDER_PASWRD = "mail.sender.password";
    private static final String MAIL_SMTPS_AUTH = "mail.smtps.auth";
    private static final String MAIL_SMTPS_STARTTLS_ENABLE = "mail.smtps.starttls.enable";
    private static final String MAIL_SMTPS_DEBUG = "mail.smtps.debug";
    private static final String SMS_PROVIDER_URL = "sms.provider.url";
    private static final String SMS_SENDER_USERNAME = "sms.sender.username";
    private static final String SMS_SENDER_PASWRD = "sms.sender.password";
    private static final String SMS_SENDER = "sms.sender";
    private static final String SMS_PRIORITY_ENABLED = "sms.priority.enabled";
    private static final String COMMON_PROPERTIES_FILES = "common.properties.files";
    private static final String DEV_MODE = "dev.mode";
    private static final String MAIL_ENABLED = "mail.enabled";
    private static final String SMS_ENABLED = "sms.enabled";
    private static final String USER_PASWRD_EXPIRY_DAYS = "user.pwd.expiry.days";
    private static final String SMS_ERROR_CODES = "sms.error.codes";
    private static final String MULTITENANCY_ENABLED = "multitenancy.enabled";
    private static final String APP_VERSION = "app.version";
    private static final String APP_BUILD_NO = "app.build.no";
    private static final String APP_RELEASE_NO = "%s_%s";
    private static final String APP_CORE_BUILD_NO = "app.core.build.no";
    private static final String ISSUE_REPORT_URL = "issue.report.url";
    private static final String PORTAL_FEATURE_ENABLED = "portal.feature.enabled";
    private static final String STATEWIDE_MIGRATION_REQUIRED = "statewide.migration.required";
    private static final String HIBERNATE_JDBC_BATCH_SIZE = "hibernate.jdbc.batch_size";
    private static final String USER_PASWRD_STRENGTH = "user.pwd.strength";
    private static final String REDIS_ENABLE_SENTINEL = "redis.enable.sentinel";
    private static final String REDIS_SENTINEL_HOSTS = "redis.sentinel.hosts";
    private static final String REDIS_SENTINEL_MASTER_NAME = "redis.sentinel.master.name";
    private static final String REDIS_ENABLE_EMBEDDED = "redis.enable.embedded";
    private static final String REDIS_HOST_NAME = "redis.host.name";
    private static final String REDIS_HOST_PORT = "redis.host.port";
    private static final String MASTER_SERVER = "master.server";
    private static final String DB_MIGRATION_ENABLED = "db.migration.enabled";
    private static final String FLYWAY_VALIDATEON_MIGRATE = "db.flyway.validateon.migrate";
    private static final String FLYWAY_MIGRATION_REPAIR = "db.flyway.migration.repair";
    private static final String SEARCH_HOSTS = "elasticsearch.hosts";
    private static final String SEARCH_PORT = "elasticsearch.port";
    private static final String SEARCH_CLUSTER_NAME = "elasticsearch.cluster.name";
    private static final String CDN_URL = "cdn.domain.url";
    private static final String SERVICES_USER_CREATE_URL = "egov.services.user.create.url";
    private static final String STATE_WIDE_SCHEMA_NAME = "statewide.schema.name";
    private static final String SERVICES_WORKFLOW_URL = "egov.services.workflow.url";
    @Autowired
    private Environment environment;

    @Bean
    public static PropertySourcesPlaceholderConfigurer applicationPropertyPlaceHolderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    public String fileStoreBaseDir() {
        return this.environment.getProperty(FILESTORE_BASE_DIR);
    }

    public String filestoreServiceBeanName() {
        return this.environment.getProperty(FILESTORESERVICE_BEANNAME);
    }

    public String defaultDatePattern() {
        return this.environment.getProperty("default.date.pattern");
    }

    public Integer mailPort() {
        return (Integer)this.environment.getProperty(MAIL_PORT, Integer.class);
    }

    public String mailHost() {
        return this.environment.getProperty(MAIL_HOST);
    }

    public String mailProtocol() {
        return this.environment.getProperty(MAIL_PROTOCOL);
    }

    public String mailSenderUsername() {
        return this.environment.getProperty(MAIL_SENDER_USERNAME);
    }

    public String mailSenderPassword() {
        return this.environment.getProperty(MAIL_SENDER_PASWRD);
    }

    public String mailSMTPSAuth() {
        return this.environment.getProperty(MAIL_SMTPS_AUTH);
    }

    public String mailStartTLSEnabled() {
        return this.environment.getProperty(MAIL_SMTPS_STARTTLS_ENABLE);
    }

    public String mailSMTPSDebug() {
        return this.environment.getProperty(MAIL_SMTPS_DEBUG);
    }

    public String smsProviderURL() {
        return this.environment.getProperty(SMS_PROVIDER_URL);
    }

    public String smsSenderUsername() {
        return this.environment.getProperty(SMS_SENDER_USERNAME);
    }

    public String smsSenderPassword() {
        return this.environment.getProperty(SMS_SENDER_PASWRD);
    }

    public String smsSender() {
        return this.environment.getProperty(SMS_SENDER);
    }

    public boolean smsPriorityEnabled() {
        return (Boolean)this.environment.getProperty(SMS_PRIORITY_ENABLED, Boolean.class);
    }

    public String[] commonMessageFiles() {
        return this.environment.getProperty(COMMON_PROPERTIES_FILES).split(",");
    }

    public boolean devMode() {
        return (Boolean)this.environment.getProperty(DEV_MODE, Boolean.class);
    }

    public boolean emailEnabled() {
        return (Boolean)this.environment.getProperty(MAIL_ENABLED, Boolean.class);
    }

    public boolean smsEnabled() {
        return (Boolean)this.environment.getProperty(SMS_ENABLED, Boolean.class);
    }

    public Integer userPasswordExpiryInDays() {
        return (Integer)this.environment.getProperty(USER_PASWRD_EXPIRY_DAYS, Integer.class);
    }

    public List<String> smsErrorCodes() {
        return Arrays.asList(this.environment.getProperty(SMS_ERROR_CODES).split(","));
    }

    public String smsResponseMessageForCode(String errorCode) {
        return this.environment.getProperty(errorCode, "No Message");
    }

    public boolean multiTenancyEnabled() {
        return (Boolean)this.environment.getProperty(MULTITENANCY_ENABLED, Boolean.class);
    }

    public String getProperty(String propKey) {
        return this.environment.getProperty(propKey, "");
    }

    public <T> T getProperty(String propKey, Class<T> type) {
        return (T)this.environment.getProperty(propKey, type);
    }

    public String appVersion() {
        return this.environment.getProperty(APP_VERSION, "");
    }

    public String appBuildNo() {
        return this.environment.getProperty(APP_BUILD_NO, "");
    }

    public String appCoreBuildNo() {
        return this.environment.getProperty(APP_CORE_BUILD_NO, "");
    }

    public String issueReportingUrl() {
        return this.environment.getProperty(ISSUE_REPORT_URL, "");
    }

    public List<String> portalEnabledFeatures() {
        return Arrays.asList(this.environment.getProperty(PORTAL_FEATURE_ENABLED).split(","));
    }

    public boolean statewideMigrationRequired() {
        return (Boolean)this.environment.getProperty(STATEWIDE_MIGRATION_REQUIRED, Boolean.class, (Object)Boolean.FALSE);
    }

    public Integer getBatchUpdateSize() {
        return (Integer)this.environment.getProperty(HIBERNATE_JDBC_BATCH_SIZE, Integer.class);
    }

    public String passwordStrength() {
        return this.environment.getProperty(USER_PASWRD_STRENGTH);
    }

    public boolean sentinelEnabled() {
        return (Boolean)this.environment.getProperty(REDIS_ENABLE_SENTINEL, Boolean.class);
    }

    public List<String> sentinelHosts() {
        return Arrays.asList(this.environment.getProperty(REDIS_SENTINEL_HOSTS).split(","));
    }

    public String sentinelMasterName() {
        return this.environment.getProperty(REDIS_SENTINEL_MASTER_NAME);
    }

    public boolean usingEmbeddedRedis() {
        return (Boolean)this.environment.getProperty(REDIS_ENABLE_EMBEDDED, Boolean.class);
    }

    public String redisHost() {
        return this.environment.getProperty(REDIS_HOST_NAME);
    }

    public int redisPort() {
        return (Integer)this.environment.getProperty(REDIS_HOST_PORT, Integer.class);
    }

    public boolean isMasterServer() {
        return (Boolean)this.environment.getProperty(MASTER_SERVER, Boolean.class);
    }

    public boolean dbMigrationEnabled() {
        return (Boolean)this.environment.getProperty(DB_MIGRATION_ENABLED, Boolean.class);
    }

    public boolean flywayValidateonMigrate() {
        return (Boolean)this.environment.getProperty(FLYWAY_VALIDATEON_MIGRATE, Boolean.class);
    }

    public boolean flywayRepair() {
        return (Boolean)this.environment.getProperty(FLYWAY_MIGRATION_REPAIR, Boolean.class);
    }

    public List<String> searchHosts() {
        return Arrays.asList(this.environment.getProperty(SEARCH_HOSTS).split(","));
    }

    public int searchPort() {
        return Integer.parseInt(this.environment.getProperty(SEARCH_PORT));
    }

    public String searchClusterName() {
        return this.environment.getProperty(SEARCH_CLUSTER_NAME);
    }

    public String applicationReleaseNo() {
        return String.format(APP_RELEASE_NO, this.appVersion(), this.appBuildNo());
    }

    public String cdnURL() {
        return this.environment.getProperty(CDN_URL, "");
    }

    public String getCreateUserServiceUrl() {
        return this.environment.getProperty(SERVICES_USER_CREATE_URL);
    }

    public String statewideSchemaName() {
        return this.environment.getProperty(STATE_WIDE_SCHEMA_NAME);
    }

    public String getServicesWorkflowUrl() {
        return this.environment.getProperty(SERVICES_WORKFLOW_URL);
    }
}

