/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.egov.infra.config.properties.ApplicationProperties;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

@Configuration
public class DBMigrationConfiguration {
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    @DependsOn(value={"dataSource"})
    public Flyway flyway(DataSource dataSource, @Qualifier(value="cities") List<String> cities) {
        if (this.applicationProperties.dbMigrationEnabled()) {
            String mainMigrationFilePath = this.applicationProperties.getProperty("db.flyway.main.migration.file.path");
            String sampleMigrationFilePath = this.applicationProperties.getProperty("db.flyway.sample.migration.file.path");
            String tenantMigrationFilePath = this.applicationProperties.getProperty("db.flyway.tenant.migration.file.path");
            boolean devMode = this.applicationProperties.devMode();
            cities.stream().forEach(schema -> {
                if (devMode) {
                    this.migrateDatabase(dataSource, (String)schema, mainMigrationFilePath, sampleMigrationFilePath, String.format(tenantMigrationFilePath, schema));
                } else {
                    this.migrateDatabase(dataSource, (String)schema, mainMigrationFilePath, String.format(tenantMigrationFilePath, schema));
                }
            });
            if (this.applicationProperties.statewideMigrationRequired() && !devMode) {
                String statewideMigrationFilePath = this.applicationProperties.getProperty("db.flyway.statewide.migration.file.path");
                String statewideSchemaName = this.applicationProperties.getProperty("statewide.schema.name");
                this.migrateDatabase(dataSource, statewideSchemaName, mainMigrationFilePath, statewideMigrationFilePath);
            } else if (!devMode) {
                String statewideSchemaName = this.applicationProperties.getProperty("statewide.schema.name");
                this.migrateDatabase(dataSource, statewideSchemaName, mainMigrationFilePath);
            }
        }
        return new Flyway();
    }

    private void migrateDatabase(DataSource dataSource, String schema, String ... locations) {
        Flyway flyway = new Flyway();
        flyway.setBaselineOnMigrate(true);
        flyway.setValidateOnMigrate(this.applicationProperties.flywayValidateonMigrate());
        flyway.setOutOfOrder(true);
        flyway.setLocations(locations);
        flyway.setDataSource(dataSource);
        flyway.setSchemas(new String[]{schema});
        if (this.applicationProperties.flywayRepair()) {
            flyway.repair();
        }
        flyway.migrate();
    }

    @Bean(name={"tenants"}, autowire=Autowire.BY_NAME)
    public List<String> tenants() {
        ArrayList<String> tenants = new ArrayList<String>();
        this.environment.getPropertySources().iterator().forEachRemaining(propertySource -> {
            if (propertySource instanceof MapPropertySource) {
                ((Map)((MapPropertySource)propertySource).getSource()).forEach((key, value) -> {
                    if (key.startsWith("tenant.")) {
                        tenants.add(value.toString());
                    }
                });
            }
        });
        return tenants;
    }
}

