/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.datasource.routing;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.egov.infra.config.persistence.datasource.routing.DatasourceType;
import org.egov.infra.config.persistence.datasource.routing.DatasourceTypeHolder;
import org.egov.infra.config.persistence.datasource.routing.RoutingDatasourceConfigCondition;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Conditional(value={RoutingDatasourceConfigCondition.class})
public class ReadOnlyDatasourceInterceptor
implements Ordered {
    private int order;

    public int getOrder() {
        return this.order;
    }

    @Value(value="20")
    public void setOrder(int order) {
        this.order = order;
    }

    @Pointcut(value="@annotation(org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly)")
    public void readOnlyAnnotatedMethods() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(readOnly)")
    public Object proceed(ProceedingJoinPoint joinPoint, ReadOnly readOnly) throws Throwable {
        try {
            DatasourceTypeHolder.setDataSourceType(DatasourceType.READONLY);
            Object result = joinPoint.proceed();
            DatasourceTypeHolder.clear();
            Object object = result;
            return object;
        }
        finally {
            DatasourceTypeHolder.clear();
        }
    }
}

