/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.filestore.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.impl.LocalDiskFileStoreService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class LocalDiskFileStoreServiceTest {
    private static Path tempFilePath = Paths.get(System.getProperty("user.home") + File.separator + "testtmpr", new String[0]);
    private LocalDiskFileStoreService diskFileService;
    private ApplicationProperties applicationProperties = (ApplicationProperties)Mockito.mock(ApplicationProperties.class);

    private void deleteTempFiles(File newFile, FileStoreMapper map) throws IOException {
        Files.deleteIfExists(newFile.toPath());
        Path storePath = Paths.get(System.getProperty("user.home") + File.separator + "testfilestore", new String[0]);
        Files.deleteIfExists(Paths.get(storePath.toString(), map.getFileStoreId().toString()));
    }

    private File createTempFileWithContent() throws IOException {
        File newFile = Files.createTempFile(tempFilePath, "xyz", "txt", new FileAttribute[0]).toFile();
        FileUtils.write((File)newFile, (CharSequence)"Test");
        return newFile;
    }

    @Before
    public void beforeTest() throws IOException {
        if (!Files.exists(tempFilePath, new LinkOption[0])) {
            Files.createDirectories(tempFilePath, new FileAttribute[0]);
        }
        Mockito.when((Object)this.applicationProperties.fileStoreBaseDir()).thenReturn((Object)(System.getProperty("user.home") + File.separator + "testfilestore"));
        this.diskFileService = new LocalDiskFileStoreService(this.applicationProperties);
    }

    @AfterClass
    public static void afterTest() throws IOException {
        Files.deleteIfExists(tempFilePath);
        Path storePath = Paths.get(System.getProperty("user.home") + File.separator + "testfilestore", new String[0]);
        try {
            Files.walkFileTree(storePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public final void testUploadFile() throws IOException {
        File newFile = this.createTempFileWithContent();
        FileStoreMapper map = this.diskFileService.store(newFile, "fileName", "testmodule", "text/plain");
        this.deleteTempFiles(newFile, map);
        Assert.assertNotNull((Object)map.getFileStoreId());
    }

    @Test(expected=ApplicationRuntimeException.class)
    public final void testUploadFileFail() throws IOException {
        File newFile = new File("file.txt");
        this.diskFileService.store(newFile, "fileName", "testmodule", "text/plain");
    }

    @Test
    public final void testUploadInputStream() throws IOException {
        File newFile = this.createTempFileWithContent();
        FileStoreMapper map = this.diskFileService.store((InputStream)new FileInputStream(newFile), "nofile", "text/plain", "testmodule");
        this.deleteTempFiles(newFile, map);
        Assert.assertNotNull((Object)map.getFileStoreId());
    }

    @Test
    public final void testUploadSetOfFile() throws IOException {
        HashSet<File> files = new HashSet<File>();
        for (int no = 0; no < 10; ++no) {
            File newFile = Files.createTempFile(tempFilePath, "xyz" + no, "txt", new FileAttribute[0]).toFile();
            FileUtils.write((File)newFile, (CharSequence)"Test");
            files.add(newFile);
        }
        for (File file : files) {
            Files.deleteIfExists(file.toPath());
        }
    }

    @Test
    public final void testUploadStreams() throws IOException {
        HashSet<FileInputStream> files = new HashSet<FileInputStream>();
        for (int no = 0; no < 10; ++no) {
            File newFile = Files.createTempFile(tempFilePath, "xyz" + no, "txt", new FileAttribute[0]).toFile();
            FileUtils.write((File)newFile, (CharSequence)"Test");
            FileInputStream fin = new FileInputStream(newFile);
            files.add(fin);
        }
        FileUtils.deleteDirectory((File)tempFilePath.toFile());
    }

    @Test
    public final void testFetch() throws IOException {
        File newFile = this.createTempFileWithContent();
        FileStoreMapper map = this.diskFileService.store(newFile, "fileName", "text/plain", "test");
        File file = this.diskFileService.fetch(map, "testmodule");
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getName().equals(map.getFileStoreId().toString()));
        this.deleteTempFiles(newFile, map);
    }

    @Test(expected=ApplicationRuntimeException.class)
    public final void testFetchFailNonExisting() throws IOException {
        FileStoreMapper map = new FileStoreMapper(UUID.randomUUID().toString(), "fileName");
        this.diskFileService.fetch(map, "testmoduleNo");
    }

    @Test
    public final void testFetchAll() throws IOException {
        HashSet<Object> files = new HashSet<Object>();
        for (int no = 0; no < 10; ++no) {
            File newFile = Files.createTempFile(tempFilePath, "xyz" + no, "txt", new FileAttribute[0]).toFile();
            FileUtils.write((File)newFile, (CharSequence)"Test");
            files.add(newFile);
        }
        HashSet<FileStoreMapper> maps = new HashSet<FileStoreMapper>();
        for (File file : files) {
            maps.add(this.diskFileService.store(file, "fileName", "text/plain", "testmodule"));
        }
        Set returnfiles = this.diskFileService.fetchAll(maps, "testmodule");
        Assert.assertNotNull((Object)returnfiles);
        Assert.assertTrue((returnfiles.size() == 10 ? 1 : 0) != 0);
        for (File file : files) {
            Files.deleteIfExists(file.toPath());
        }
    }

    @Test
    public final void testDeleteFile() throws IOException {
        File newFile = Files.createTempFile(tempFilePath, "xyz", "txt", new FileAttribute[0]).toFile();
        FileUtils.write((File)newFile, (CharSequence)"Test");
        FileStoreMapper fileStoreMapper = this.diskFileService.store(newFile, "fileName", "text/plain", "testmodule");
        this.diskFileService.delete(fileStoreMapper.getFileStoreId(), "testmodule");
        Files.deleteIfExists(newFile.toPath());
    }
}

