/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.inbox;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderService;
import org.egov.infra.workflow.service.StateService;
import org.egov.infra.workflow.service.WorkflowActionService;
import org.egov.infra.workflow.service.WorkflowTypeService;
import org.egov.infstr.services.EISServeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InboxRenderServiceDeligate<T extends StateAware> {
    private static final Logger LOG = LoggerFactory.getLogger(InboxRenderServiceDeligate.class);
    private static final String INBOX_RENDER_SERVICE_SUFFIX = "InboxRenderService";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private StateService stateService;
    @Autowired
    @Qualifier(value="eisService")
    private EISServeable eisService;
    @Autowired
    private WorkflowTypeService workflowTypeService;
    @Autowired
    private WorkflowActionService workflowActionService;
    private static final Map<String, WorkflowTypes> WORKFLOWTYPE_CACHE = new ConcurrentHashMap<String, WorkflowTypes>();

    public List<T> getInboxItems(Long userId) {
        return this.fetchInboxItems(userId, this.eisService.getPositionsForUser(userId, new Date()).parallelStream().map(position -> position.getId()).collect(Collectors.toList()));
    }

    public List<T> getInboxDraftItems(Long userId) {
        return this.fetchInboxDraftItems(userId, this.eisService.getPositionsForUser(userId, new Date()).parallelStream().map(position -> position.getId()).collect(Collectors.toList()));
    }

    public List<StateHistory> getWorkflowHistory(Long stateId) {
        return new LinkedList<StateHistory>(this.stateService.getStateById(stateId).getHistory());
    }

    public List<T> fetchInboxItems(Long userId, List<Long> owners) {
        ArrayList<T> assignedWFItems = new ArrayList<T>();
        if (!owners.isEmpty()) {
            List<String> wfTypes = this.stateService.getAssignedWorkflowTypeNames(owners);
            for (String wfType : wfTypes) {
                Optional<InboxRenderService<T>> inboxRenderService = this.getInboxRenderService(wfType);
                if (!inboxRenderService.isPresent()) continue;
                assignedWFItems.addAll(inboxRenderService.get().getAssignedWorkflowItems(userId, owners));
            }
        }
        return assignedWFItems;
    }

    public List<T> fetchInboxDraftItems(Long userId, List<Long> owners) {
        ArrayList<T> draftWfItems = new ArrayList<T>();
        if (!owners.isEmpty()) {
            List<String> wfTypes = this.stateService.getAssignedWorkflowTypeNames(owners);
            for (String wfType : wfTypes) {
                Optional<InboxRenderService<T>> inboxRenderService = this.getInboxRenderService(wfType);
                if (!inboxRenderService.isPresent()) continue;
                draftWfItems.addAll(inboxRenderService.get().getDraftWorkflowItems(userId, owners));
            }
        }
        return draftWfItems;
    }

    public WorkflowTypes getWorkflowType(String wfType) {
        WorkflowTypes workflowType = WORKFLOWTYPE_CACHE.get(wfType);
        if (workflowType == null && (workflowType = this.workflowTypeService.getEnabledWorkflowTypeByType(wfType)) != null) {
            WORKFLOWTYPE_CACHE.put(wfType, workflowType);
        }
        return workflowType;
    }

    public Optional<InboxRenderService<T>> getInboxRenderService(String wfType) {
        InboxRenderService inboxRenderService = null;
        try {
            if (this.getWorkflowType(wfType) != null) {
                inboxRenderService = (InboxRenderService)this.applicationContext.getBean(wfType.concat(INBOX_RENDER_SERVICE_SUFFIX), InboxRenderService.class);
            }
        }
        catch (BeansException e) {
            LOG.warn("InboxRenderService bean for {} not found, have you defined {}InboxRenderService bean ?", new Object[]{wfType, wfType, e});
        }
        return Optional.ofNullable(inboxRenderService);
    }

    public String getNextAction(State state) {
        String nextAction = "";
        if (state.getNextAction() != null) {
            WorkflowAction workflowAction = this.workflowActionService.getWorkflowActionByNameAndType(state.getNextAction(), state.getType());
            nextAction = workflowAction == null ? state.getNextAction() : (workflowAction.getDescription() == null ? state.getNextAction() : workflowAction.getDescription());
        }
        return nextAction;
    }
}

