/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.workflow.entity.State;
import org.egov.pims.commons.Position;
import org.hibernate.annotations.Immutable;

@Entity
@Immutable
@Table(name="eg_wf_state_history")
@SequenceGenerator(name="SEQ_EG_WF_STATE_HISTORY", sequenceName="SEQ_EG_WF_STATE_HISTORY", allocationSize=1)
public class StateHistory
implements Serializable {
    private static final long serialVersionUID = -2286621991905578107L;
    static final String SEQ_STATEHISTORY = "SEQ_EG_WF_STATE_HISTORY";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ_EG_WF_STATE_HISTORY")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="createdBy")
    private User createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="lastModifiedBy")
    private User lastModifiedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedDate;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="state_id")
    private State state;
    @NotNull
    private String value;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER_POS")
    private Position ownerPosition;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="OWNER_USER")
    private User ownerUser;
    private String senderName;
    private String nextAction;
    private String comments;
    private String natureOfTask;
    private String extraInfo;
    private Date dateInfo;
    private Date extraDateInfo;

    StateHistory() {
    }

    public StateHistory(State state) {
        this.state = state;
        this.createdBy = state.getCreatedBy();
        this.createdDate = state.getCreatedDate() != null ? state.getCreatedDate() : null;
        this.lastModifiedBy = state.getLastModifiedBy();
        this.lastModifiedDate = state.getLastModifiedDate() != null ? state.getLastModifiedDate() : null;
        this.value = state.getValue();
        this.ownerPosition = state.getOwnerPosition();
        this.ownerUser = state.getOwnerUser();
        this.senderName = state.getSenderName();
        this.nextAction = state.getNextAction();
        this.comments = state.getComments();
        this.extraInfo = state.getExtraInfo();
        this.dateInfo = state.getDateInfo();
        this.extraDateInfo = state.getExtraDateInfo();
        this.natureOfTask = state.getNatureOfTask();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Position getOwnerPosition() {
        return this.ownerPosition;
    }

    public void setOwnerPosition(Position ownerPosition) {
        this.ownerPosition = ownerPosition;
    }

    public User getOwnerUser() {
        return this.ownerUser;
    }

    public void setOwnerUser(User ownerUser) {
        this.ownerUser = ownerUser;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getNextAction() {
        return this.nextAction;
    }

    public void setNextAction(String nextAction) {
        this.nextAction = nextAction;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getNatureOfTask() {
        return this.natureOfTask;
    }

    public void setNatureOfTask(String natureOfTask) {
        this.natureOfTask = natureOfTask;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Date getDateInfo() {
        return this.dateInfo;
    }

    public void setDateInfo(Date dateInfo) {
        this.dateInfo = dateInfo;
    }

    public Date getExtraDateInfo() {
        return this.extraDateInfo;
    }

    public void setExtraDateInfo(Date extraDateInfo) {
        this.extraDateInfo = extraDateInfo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public User getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(User lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

