/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.struts.actions.common.geo;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.gis.model.GeoKmlInfo;
import org.egov.infra.gis.service.GeoLocationService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParentPackage(value="egov")
public class GeoLocationAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoLocationAction.class);
    private String kmlDataModelKey;
    private String kmlUrlPath;

    public Object getModel() {
        return null;
    }

    @SkipValidation
    public String getKMLStream() {
        block5: {
            try {
                LOGGER.debug("GeoLocationAction | getKMLStream | Start");
                GeoKmlInfo geoKmlInfo = GeoLocationService.getKmlDataFromCache(this.kmlDataModelKey);
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.putAll(geoKmlInfo.getWardWiseColor());
                dataMap.putAll(geoKmlInfo.getColorCodes());
                Configuration cfg = new Configuration();
                HttpServletResponse response = ServletActionContext.getResponse();
                response.setContentType("text/xml");
                if (null != this.kmlUrlPath) {
                    try {
                        final URL url = new URL(this.kmlUrlPath);
                        cfg.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

                            protected URL getURL(String urlName) {
                                return url;
                            }
                        });
                        Template tpl = cfg.getTemplate("");
                        tpl.process(dataMap, (Writer)response.getWriter());
                        break block5;
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error("Error occurred while loading GIS", (Throwable)e);
                        throw new ValidationException(Arrays.asList(new ValidationError("kmlUrlPath", e.getMessage())));
                    }
                }
                ClassTemplateLoader ctl = new ClassTemplateLoader(GeoLocationAction.class, "/reports/templates");
                cfg.setTemplateLoader((TemplateLoader)ctl);
                Template tpl = cfg.getTemplate("base.kml");
                tpl.process(dataMap, (Writer)response.getWriter());
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading GIS", (Throwable)e);
                throw new ValidationException(Arrays.asList(new ValidationError("kmlLoading", e.getMessage())));
            }
        }
        LOGGER.debug("GeoLocationAction | getKMLStream | End");
        return null;
    }

    public String getKmlDataModelKey() {
        return this.kmlDataModelKey;
    }

    public void setKmlDataModelKey(String kmlDataModelKey) {
        this.kmlDataModelKey = kmlDataModelKey;
    }

    public String getKmlUrlPath() {
        return this.kmlUrlPath;
    }

    public void setKmlUrlPath(String kmlUrlPath) {
        this.kmlUrlPath = kmlUrlPath;
    }
}

