/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.spring.interceptor;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.web.spring.annotation.DuplicateRequestToken;
import org.egov.infra.web.spring.annotation.ValidateToken;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class DuplicateFormSubmissionInterceptor
extends HandlerInterceptorAdapter {
    private static final String TOKEN_NAME = "tokenName";
    private static final String ERROR_PAGE = "/error/409";
    private String errorPage = "/error/409";
    private static final long ORPHEN_TOKEN_REMOVAL_DELAY = 1800000L;
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler != null && handler instanceof HandlerMethod && ((HandlerMethod)handler).getMethodAnnotation(ValidateToken.class) != null) {
            HttpSession session;
            HttpSession httpSession = session = request.getSession();
            synchronized (httpSession) {
                if (!this.havingValidToken(request, session)) {
                    response.sendRedirect(request.getContextPath() + this.errorPage);
                    return false;
                }
                this.removeToken(request, session);
            }
        }
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler != null && handler instanceof HandlerMethod) {
            BindingResult bindingResult;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            HttpSession session = request.getSession();
            if (handlerMethod.getMethodAnnotation(DuplicateRequestToken.class) != null) {
                this.addToken(request, session);
            } else if (handlerMethod.getMethodAnnotation(ValidateToken.class) != null && (bindingResult = DuplicateFormSubmissionInterceptor.getBindingResult(modelAndView)) != null && bindingResult.hasErrors()) {
                this.addToken(request, session);
            }
        }
    }

    private static BindingResult getBindingResult(ModelAndView modelAndView) {
        Set paramNames = modelAndView.getModelMap().keySet();
        return (BindingResult)modelAndView.getModelMap().get((Object)paramNames.parallelStream().filter(e -> e.startsWith(BindingResult.MODEL_KEY_PREFIX)).findFirst().get());
    }

    private void addToken(HttpServletRequest request, HttpSession session) {
        String tokenName = RandomStringUtils.randomAlphanumeric((int)10);
        String tokenValue = UUID.randomUUID().toString();
        DuplicateFormSubmissionInterceptor.scheduleForRemoval(session, tokenName);
        request.setAttribute(TOKEN_NAME, (Object)tokenName);
        request.setAttribute(tokenName, (Object)tokenValue);
        session.setAttribute(tokenName, (Object)tokenValue);
    }

    private boolean havingValidToken(HttpServletRequest request, HttpSession session) {
        String tokenName = StringUtils.defaultString((String)request.getParameter(TOKEN_NAME), (String)"NOTOKEN");
        String tokenValue = request.getParameter(tokenName);
        return tokenValue != null && session.getAttribute(tokenName) != null && session.getAttribute(tokenName).equals(tokenValue);
    }

    private void removeToken(HttpServletRequest request, HttpSession session) {
        session.removeAttribute(request.getParameter(TOKEN_NAME));
    }

    private static void scheduleForRemoval(HttpSession session, String tokenName) {
        Runnable tokenRemoverTask = () -> {
            try {
                session.removeAttribute(tokenName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        executor.schedule(tokenRemoverTask, 1800000L, TimeUnit.MILLISECONDS);
    }
}

