/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.web.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplicationTenantResolverFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationTenantResolverFilter.class);
    @Autowired
    private ApplicationProperties applicationProperties;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String domainURL = WebUtils.extractRequestedDomainName((HttpServletRequest)request);
        LOG.debug("Resolved domain as  {}", (Object)ApplicationThreadLocals.getDomainName());
        ApplicationThreadLocals.setTenantID(this.applicationProperties.getProperty("tenant." + domainURL));
        LOG.debug("Resolved tenant as  {}", (Object)ApplicationThreadLocals.getTenantID());
        ApplicationThreadLocals.setDomainName(domainURL);
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

