/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.search.elastic.entity;

import java.math.BigDecimal;
import java.util.Date;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.search.elastic.entity.CollectionIndex;

public class CollectionIndexBuilder {
    private final CollectionIndex collectionIndex = new CollectionIndex();

    public CollectionIndexBuilder(Date receiptDate, String receiptNumber, String billingService, String paymentMode, BigDecimal totalAmount, String channel, String status) {
        this.collectionIndex.setReceiptDate(receiptDate);
        this.collectionIndex.setReceiptNumber(receiptNumber);
        this.collectionIndex.setBillingService(billingService);
        this.collectionIndex.setPaymentMode(paymentMode);
        this.collectionIndex.setTotalAmount(totalAmount);
        this.collectionIndex.setChannel(channel);
        this.collectionIndex.setStatus(status);
    }

    public CollectionIndexBuilder consumerCode(String consumerCode) {
        this.collectionIndex.setConsumerCode(consumerCode);
        return this;
    }

    public CollectionIndexBuilder arrearAmount(BigDecimal arrearAmount) {
        this.collectionIndex.setArrearAmount(arrearAmount);
        return this;
    }

    public CollectionIndexBuilder penaltyAmount(BigDecimal penaltyAmount) {
        this.collectionIndex.setPenaltyAmount(penaltyAmount);
        return this;
    }

    public CollectionIndexBuilder currentAmount(BigDecimal currentAmount) {
        this.collectionIndex.setCurrentAmount(currentAmount);
        return this;
    }

    public CollectionIndexBuilder advanceAmount(BigDecimal advanceAmount) {
        this.collectionIndex.setAdvanceAmount(advanceAmount);
        return this;
    }

    public CollectionIndexBuilder paymentGateway(String paymentGateway) {
        this.collectionIndex.setPaymentGateway(paymentGateway);
        return this;
    }

    public CollectionIndexBuilder billNumber(String billNumber) {
        this.collectionIndex.setBillNumber(billNumber);
        return this;
    }

    public CollectionIndexBuilder latePaymentChargesAmount(BigDecimal latePaymentCharges) {
        this.collectionIndex.setLatePaymentCharges(latePaymentCharges);
        return this;
    }

    public CollectionIndexBuilder arrearCess(BigDecimal arrearCess) {
        this.collectionIndex.setArrearCess(arrearCess);
        return this;
    }

    public CollectionIndexBuilder currentCess(BigDecimal currentCess) {
        this.collectionIndex.setCurrentCess(currentCess);
        return this;
    }

    public CollectionIndexBuilder installmentFrom(String installmentFrom) {
        this.collectionIndex.setInstallmentFrom(installmentFrom);
        return this;
    }

    public CollectionIndexBuilder installmentTo(String installmentTo) {
        this.collectionIndex.setInstallmentTo(installmentTo);
        return this;
    }

    public CollectionIndexBuilder consumerName(String consumerName) {
        this.collectionIndex.setConsumerName(consumerName);
        return this;
    }

    public CollectionIndex build() throws ApplicationRuntimeException {
        this.validate();
        return this.collectionIndex;
    }

    public CollectionIndexBuilder reductionAmount(BigDecimal reductionAmount) {
        this.collectionIndex.setReductionAmount(reductionAmount);
        return this;
    }

    public CollectionIndexBuilder receiptCreator(String receiptCreator) {
        this.collectionIndex.setReceiptCreator(receiptCreator);
        return this;
    }

    private void validate() throws ApplicationRuntimeException {
        if (this.collectionIndex.getReceiptDate() == null) {
            throw new ApplicationRuntimeException("Receipt Date is mandatory");
        }
        if (this.collectionIndex.getReceiptNumber() == null) {
            throw new ApplicationRuntimeException("Receipt Number is mandatory");
        }
        if (this.collectionIndex.getPaymentMode() == null) {
            throw new ApplicationRuntimeException("Payment Mode is mandatory");
        }
        if (this.collectionIndex.getTotalAmount() == null) {
            throw new ApplicationRuntimeException("Total Amount is mandatory");
        }
        if (this.collectionIndex.getChannel() == null) {
            throw new ApplicationRuntimeException("Channel is mandatory");
        }
        if (this.collectionIndex.getStatus() == null) {
            throw new ApplicationRuntimeException("Receipt Status is mandatory");
        }
    }
}

