/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.script.entity;

import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.script.CompiledScript;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.component.Period;
import org.hibernate.search.annotations.DocumentId;
import org.joda.time.DateTime;

@Entity
@Table(name="eg_script")
@SequenceGenerator(name="SEQ_EG_SCRIPT", sequenceName="SEQ_EG_SCRIPT", allocationSize=1)
@NamedQueries(value={@NamedQuery(name="Script.findByName", query="select s from Script s where s.name=:name and current_date between period.startDate and period.endDate"), @NamedQuery(name="Script.findByNameAndPeriod", query="select s from Script as s where s.name=:name and :date between period.startDate and period.endDate")})
public class Script
extends AbstractAuditable {
    private static final long serialVersionUID = -2464312999181924258L;
    public static final String SEQ_SCRIPT = "SEQ_EG_SCRIPT";
    public static final String BY_NAME = "Script.findByName";
    public static final String BY_NAME_AND_DATE = "Script.findByNameAndPeriod";
    @Id
    @GeneratedValue(generator="SEQ_EG_SCRIPT", strategy=GenerationType.SEQUENCE)
    @DocumentId
    private Long id;
    private String type;
    private String script;
    private String name;
    @Embedded
    private Period period;
    @Transient
    private CompiledScript compiledScript;

    Script() {
    }

    public Script(String name, String type, String script) {
        this(name, type, script, new DateTime(), new DateTime().plusYears(100));
    }

    public Script(String name, String type, String script, DateTime startDate, DateTime endDate) {
        this.name = name;
        this.type = type;
        this.script = script;
        this.period = new Period(startDate.toDate(), endDate.toDate());
    }

    @Override
    protected void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period periods) {
        this.period = periods;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }
}

