/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.scheduler.quartz;

import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.scheduler.GenericJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class AbstractQuartzJob
extends QuartzJobBean
implements GenericJob {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuartzJob.class);
    private boolean isTransactional;
    private String userName;
    @Resource(name="cities")
    protected List<String> cities;
    @Autowired
    private UserService userService;
    @Autowired
    private CityService cityService;

    protected void executeInternal(JobExecutionContext jobCtx) throws JobExecutionException {
        try {
            MDC.put((String)"appname", (String)jobCtx.getJobDetail().getKey().getName());
            if (this.isTransactional) {
                for (String tenant : this.cities) {
                    MDC.put((String)"ulbcode", (String)tenant);
                    this.prepareThreadLocal(tenant);
                    this.executeJob();
                }
            } else {
                this.executeJob();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to complete execution Scheduler ", (Throwable)ex);
            throw new JobExecutionException("Unable to execute batch job Scheduler", (Throwable)ex, false);
        }
        finally {
            ApplicationThreadLocals.clearValues();
            MDC.clear();
        }
    }

    public void setUserName(String userName) {
        this.userName = StringUtils.isBlank((String)userName) ? "egovernments" : userName;
    }

    public void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    protected City getCurrentCity() {
        return this.cityService.findAll().get(0);
    }

    protected void prepareCityThreadLocal() {
        City city = this.getCurrentCity();
        ApplicationThreadLocals.setCityCode(city.getCode());
        ApplicationThreadLocals.setCityName(city.getName());
        ApplicationThreadLocals.setMunicipalityName(city.getPreferences().getMunicipalityName());
        ApplicationThreadLocals.setDomainName(city.getDomainURL());
    }

    private void prepareThreadLocal(String tenant) {
        ApplicationThreadLocals.setTenantID(tenant);
        ApplicationThreadLocals.setUserId(this.userService.getUserByUsername(this.userName).getId());
    }
}

