/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.rest.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SimpleRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRestClient.class);

    public String getRESTResponse(String restUrl) {
        try {
            return IOUtils.toString((InputStream)HttpClientBuilder.create().build().execute((HttpUriRequest)new HttpGet(restUrl)).getEntity().getContent());
        }
        catch (IOException | UnsupportedOperationException e) {
            LOG.error("Error occurred while rest response from url {}", (Object)restUrl, (Object)e);
            return "500";
        }
    }

    public HashMap<String, Object> getRESTResponseAsMap(String restUrl) {
        return (HashMap)new Gson().fromJson(this.getRESTResponse(restUrl), new TypeToken<HashMap<String, Object>>(){}.getType());
    }
}

