/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtil.class);

    private ReportUtil() {
    }

    private static InputStream getFileAsStream(String filePath) {
        InputStream fileInputStream = null;
        String errMsg = null;
        fileInputStream = ReportUtil.class.getResourceAsStream("/custom" + filePath);
        if (fileInputStream == null) {
            fileInputStream = ReportUtil.class.getResourceAsStream(filePath);
        }
        if (fileInputStream == null) {
            errMsg = "File [" + filePath + "] could not be loaded from CLASSPATH!";
            LOGGER.error(errMsg);
            throw new ApplicationRuntimeException(errMsg);
        }
        return fileInputStream;
    }

    public static InputStream getImageAsStream(String imageName) {
        return ReportUtil.getFileAsStream("/egi/resources/global/images/" + imageName);
    }

    public static String getCityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public static InputStream getTemplateAsStream(String templateName) {
        return ReportUtil.getFileAsStream("/reports/templates/" + templateName);
    }

    public static Properties loadReportConfig() {
        Properties reportProps = new Properties();
        try {
            reportProps.load(ReportUtil.getFileAsStream("/config/reports.properties"));
            return reportProps;
        }
        catch (IOException e) {
            LOGGER.warn("Exception while loading report configuration file [/config/reports.properties]", (Throwable)e);
            return null;
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.warn("Exception while loading report configuration file [/config/reports.properties]", (Throwable)e);
            return null;
        }
    }

    public static Object fetchFromDBSql(Connection connection, String sqlQuery) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sqlQuery);
            resultSet = statement.executeQuery();
            if (resultSet != null && resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
            Object var4_5 = null;
            return var4_5;
        }
        catch (SQLException e) {
            String errMsg = "Exception while executing query [" + sqlQuery + "]";
            LOGGER.error(errMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errMsg, e);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public static Date getDate(int year, int month, int date) {
        return DateUtils.getDate(year, month, date);
    }

    public static Date today() {
        return DateUtils.today();
    }

    public static Date now() {
        return DateUtils.now();
    }

    public static Date tomorrow() {
        return DateUtils.tomorrow();
    }

    public static Date add(Date inputDate, int addType, int addAmount) {
        return DateUtils.add(inputDate, addType, addAmount);
    }

    public static String amountInWords(BigDecimal amount) {
        return NumberUtil.amountInWords(amount);
    }

    public static String formatNumber(BigDecimal number, int fractionDigits, boolean useGrouping) {
        return NumberUtil.formatNumber(number, fractionDigits, useGrouping);
    }

    public static String logoBasePath() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL(request, false);
        String imagePath = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        return imagePath;
    }

    public static String cancelledWatermarkAbsolutePath() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL(request, false);
        String imagePath = url.concat("/egi").concat("/resources/global/images/cancelled_watermark.png");
        return imagePath;
    }
}

