/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.engine.jasper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.AbstractReportService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperReportService
extends AbstractReportService<JasperReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperReportService.class);
    public static final String TEMPLATE_EXTENSION = ".jasper";
    private static final String JASPER_PROPERTIES_FILE = "config/jasperreports.properties";
    @PersistenceContext
    private EntityManager entityManager;

    public JasperReportService(int templateCacheMinSize, int templateCacheMaxSize) {
        super(templateCacheMinSize, templateCacheMaxSize);
    }

    @Override
    protected String getTemplateExtension() {
        return TEMPLATE_EXTENSION;
    }

    private JRExporter getExporter(ReportRequest reportInput, JasperPrint jasperPrint, OutputStream outputStream) {
        JRPdfExporter exporter;
        switch (reportInput.getReportFormat()) {
            case PDF: {
                exporter = new JRPdfExporter();
                if (!reportInput.isPrintDialogOnOpenReport()) break;
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PDF_JAVASCRIPT, (Object)"this.print()");
                break;
            }
            case XLS: {
                exporter = new JExcelApiExporter();
                break;
            }
            case RTF: {
                exporter = new JRRtfExporter();
                break;
            }
            case HTM: {
                exporter = new JRHtmlExporter();
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)Boolean.FALSE);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)"/images");
                break;
            }
            case TXT: {
                exporter = new JRTextExporter();
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)6);
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)12);
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.LINE_SEPARATOR, (Object)"\r\n");
                break;
            }
            case CSV: {
                exporter = new JRCsvExporter();
                break;
            }
            default: {
                throw new ApplicationRuntimeException("Invalid report format [" + (Object)((Object)reportInput.getReportFormat()) + "]");
            }
        }
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        return exporter;
    }

    private ReportOutput createReport(ReportRequest reportInput, JRDataSource dataSource) {
        try {
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)((JasperReport)this.getTemplate(reportInput.getReportTemplate())), reportInput.getReportParams(), (JRDataSource)dataSource);
            byte[] data = this.exportReport(reportInput, jasperPrint);
            return new ReportOutput(data, reportInput);
        }
        catch (Exception e) {
            String errMessage = "Exception in report creation!";
            LOGGER.error("Exception in report creation!", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in report creation!", e);
        }
    }

    @Override
    protected ReportOutput createReportFromSql(ReportRequest reportInput, Connection connection) {
        try {
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)((JasperReport)this.getTemplate(reportInput.getReportTemplate())), reportInput.getReportParams(), (Connection)connection);
            byte[] data = this.exportReport(reportInput, jasperPrint);
            return new ReportOutput(data, reportInput);
        }
        catch (Exception e) {
            String errMessage = "Exception in report creation!";
            LOGGER.error("Exception in report creation!", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in report creation!", e);
        }
    }

    private byte[] exportReport(ReportRequest reportInput, JasperPrint jasperPrint) throws JRException, IOException {
        try {
            ByteArrayOutputStream reportOutputStream = new ByteArrayOutputStream();
            JRExporter exporter = this.getExporter(reportInput, jasperPrint, reportOutputStream);
            exporter.exportReport();
            byte[] data = reportOutputStream.toByteArray();
            reportOutputStream.close();
            return data;
        }
        catch (Exception e) {
            String errMsg = "Exception in export report!";
            LOGGER.error("Exception in export report!", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in export report!", e);
        }
    }

    @Override
    protected ReportOutput createReportFromJavaBean(ReportRequest reportInput) {
        Object reportData = reportInput.getReportInputData();
        Object dataSource = null;
        dataSource = reportData == null ? new JREmptyDataSource() : (reportData.getClass().isArray() ? new JRBeanArrayDataSource((Object[])reportData, false) : (reportData instanceof Collection ? new JRBeanCollectionDataSource((Collection)reportData, false) : new JRBeanArrayDataSource(new Object[]{reportData}, false)));
        return this.createReport(reportInput, (JRDataSource)dataSource);
    }

    @Override
    protected ReportOutput createReportFromHql(ReportRequest reportInput) {
        try {
            Map<String, Object> reportParams = reportInput.getReportParams();
            if (reportParams == null) {
                reportParams = new HashMap<String, Object>();
            }
            reportParams.put("HIBERNATE_SESSION", this.entityManager.unwrap(Session.class));
            DefaultJasperReportsContext jrc = DefaultJasperReportsContext.getInstance();
            jrc.setValue("net.sf.jasperreports.hql.field.mapping.descriptions", (Object)false);
            JasperPrint jasperPrint = JasperFillManager.getInstance((JasperReportsContext)jrc).fill((JasperReport)this.getTemplate(reportInput.getReportTemplate()), reportParams);
            byte[] data = this.exportReport(reportInput, jasperPrint);
            return new ReportOutput(data, reportInput);
        }
        catch (Exception e) {
            String errMessage = "Exception in report creation!";
            LOGGER.error("Exception in report creation!", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in report creation!", e);
        }
    }

    @Override
    protected JasperReport loadTemplate(InputStream templateInputStream) {
        try {
            return (JasperReport)JRLoader.loadObject((InputStream)templateInputStream);
        }
        catch (JRException e) {
            String errMsg = "Exception while loading jasperreport template from inpust stream!";
            LOGGER.error("Exception while loading jasperreport template from inpust stream!", (Throwable)e);
            throw new ApplicationRuntimeException("Exception while loading jasperreport template from inpust stream!", e);
        }
    }

    static {
        System.setProperty("net.sf.jasperreports.properties", JASPER_PROPERTIES_FILE);
    }
}

