/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.engine;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.cache.impl.LRUCache;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.util.ReportUtil;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportService<T>
implements ReportService {
    private LRUCache<String, T> templateCache;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReportService.class);
    @PersistenceContext
    private EntityManager entityManager;

    protected abstract ReportOutput createReportFromJavaBean(ReportRequest var1);

    protected abstract ReportOutput createReportFromSql(ReportRequest var1, Connection var2);

    protected abstract ReportOutput createReportFromHql(ReportRequest var1);

    protected abstract String getTemplateExtension();

    protected abstract T loadTemplate(InputStream var1);

    private void initialize(int templateCacheMinSize, int templateCacheMaxSize) {
        this.templateCache = new LRUCache(templateCacheMinSize, templateCacheMaxSize);
    }

    public AbstractReportService(int templateCachMinSize, int templateCacheMaxSize) {
        this.initialize(templateCachMinSize, templateCacheMaxSize);
    }

    @Override
    public ReportOutput createReport(ReportRequest reportInput) {
        switch (reportInput.getReportDataSourceType()) {
            case JAVABEAN: {
                return this.createReportFromJavaBean(reportInput);
            }
            case SQL: {
                return this.createReportFromSql(reportInput);
            }
            case HQL: {
                return this.createReportFromHql(reportInput);
            }
        }
        throw new ApplicationRuntimeException("Invalid report data source type [" + (Object)((Object)reportInput.getReportDataSourceType()) + "]");
    }

    protected ReportOutput createReportFromSql(ReportRequest reportInput) {
        JdbcReportWork reportWork = new JdbcReportWork(reportInput);
        ((Session)this.entityManager.unwrap(Session.class)).doWork((Work)reportWork);
        return reportWork.getReportOutput();
    }

    protected T getTemplate(String templateName) {
        String errMsg = null;
        Object reportTemplate = this.templateCache.get(templateName);
        if (reportTemplate == null) {
            try {
                InputStream templateInputStream = ReportUtil.getTemplateAsStream(templateName + this.getTemplateExtension());
                reportTemplate = this.loadTemplate(templateInputStream);
                this.templateCache.put(templateName, reportTemplate);
                if (reportTemplate == null) {
                    errMsg = "Report template [" + templateName + "] could not be loaded";
                    LOGGER.error(errMsg);
                    throw new ApplicationRuntimeException(errMsg);
                }
            }
            catch (Exception e) {
                errMsg = "Exception in getting report template [" + templateName + "]";
                LOGGER.error(errMsg, (Throwable)e);
                throw new ApplicationRuntimeException(errMsg, e);
            }
        }
        return (T)reportTemplate;
    }

    @Override
    public boolean isValidTemplate(String templateName) {
        Object report = null;
        try {
            report = this.getTemplate(templateName);
        }
        catch (Exception e) {
            LOGGER.error(templateName + " is not a valid template name.", (Throwable)e);
        }
        return report != null;
    }

    private class JdbcReportWork
    implements Work {
        private final ReportRequest reportInput;
        private ReportOutput reportOutput;

        public JdbcReportWork(ReportRequest reportInput) {
            this.reportInput = reportInput;
        }

        public ReportOutput getReportOutput() {
            return this.reportOutput;
        }

        public void execute(Connection connection) throws SQLException {
            this.reportOutput = AbstractReportService.this.createReportFromSql(this.reportInput, connection);
        }
    }
}

