/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.validator;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CompositeUniqueCheckValidator
implements ConstraintValidator<CompositeUnique, Object> {
    private CompositeUnique unique;
    @PersistenceContext
    private EntityManager entityManager;

    public void initialize(CompositeUnique unique) {
        this.unique = unique;
    }

    public boolean isValid(Object arg0, ConstraintValidatorContext constraintValidatorContext) {
        try {
            Number id = (Number)FieldUtils.readField((Object)arg0, (String)this.unique.id(), (boolean)true);
            boolean isValid = this.checkCompositeUniqueKey(arg0, id);
            if (!isValid && this.unique.enableDfltMsg()) {
                for (String fieldName : this.unique.fields()) {
                    constraintValidatorContext.buildConstraintViolationWithTemplate(this.unique.message()).addPropertyNode(fieldName).addConstraintViolation();
                }
            }
            return isValid;
        }
        catch (IllegalAccessException e) {
            throw new ApplicationRuntimeException("Error while validating composite unique key", e);
        }
    }

    private boolean checkCompositeUniqueKey(Object arg0, Number id) throws IllegalAccessException {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(this.unique.isSuperclass() ? arg0.getClass().getSuperclass() : arg0.getClass());
        Conjunction conjunction = Restrictions.conjunction();
        for (String fieldName : this.unique.fields()) {
            Object fieldValue = FieldUtils.readField((Object)arg0, (String)fieldName, (boolean)true);
            if (this.unique.checkForNull() && fieldValue == null) {
                conjunction.add(Restrictions.isNull((String)fieldName));
                continue;
            }
            if (fieldValue instanceof String) {
                conjunction.add((Criterion)Restrictions.eq((String)fieldName, (Object)fieldValue).ignoreCase());
                continue;
            }
            conjunction.add((Criterion)Restrictions.eq((String)fieldName, (Object)fieldValue));
        }
        if (id != null) {
            conjunction.add((Criterion)Restrictions.ne((String)this.unique.id(), (Object)id));
        }
        return criteria.add((Criterion)conjunction).setProjection((Projection)Projections.id()).setMaxResults(1).uniqueResult() == null;
    }
}

