/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.messaging.sms;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.egov.infra.config.properties.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SMSService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMSService.class);
    private static final String SENDERID_PARAM_NAME = "sms.sender.req.param.name";
    private static final String USERNAME_PARAM_NAME = "sms.sender.username.req.param.name";
    private static final String PASSWORD_PARAM_NAME = "sms.sender.password.req.param.name";
    private static final String DEST_MOBILENUM_PARAM_NAME = "sms.destination.mobile.req.param.name";
    private static final String DEST_MESSAGE_PARAM_NAME = "sms.message.req.param.name";
    @Autowired
    private ApplicationProperties applicationProperties;

    public boolean sendSMS(String mobileNumber, String message) {
        if (this.applicationProperties.smsEnabled()) {
            try {
                String[] extraParms;
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost post = new HttpPost(this.applicationProperties.smsProviderURL());
                ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                urlParameters.add(new BasicNameValuePair(this.applicationProperties.getProperty(USERNAME_PARAM_NAME), this.applicationProperties.smsSenderUsername()));
                urlParameters.add(new BasicNameValuePair(this.applicationProperties.getProperty(PASSWORD_PARAM_NAME), this.applicationProperties.smsSenderPassword()));
                urlParameters.add(new BasicNameValuePair(this.applicationProperties.getProperty(SENDERID_PARAM_NAME), this.applicationProperties.smsSender()));
                urlParameters.add(new BasicNameValuePair(this.applicationProperties.getProperty(DEST_MOBILENUM_PARAM_NAME), mobileNumber));
                urlParameters.add(new BasicNameValuePair(this.applicationProperties.getProperty(DEST_MESSAGE_PARAM_NAME), message));
                if (StringUtils.isNotBlank((String)this.applicationProperties.getProperty("sms.extra.req.params")) && (extraParms = this.applicationProperties.getProperty("sms.extra.req.params").split("&")).length > 0) {
                    for (String extraParm : extraParms) {
                        String[] paramNameValue = extraParm.split("=");
                        urlParameters.add(new BasicNameValuePair(paramNameValue[0], paramNameValue[1]));
                    }
                }
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters, StandardCharsets.UTF_8));
                HttpResponse response = client.execute((HttpUriRequest)post);
                String responseCode = IOUtils.toString((InputStream)response.getEntity().getContent());
                LOGGER.info("SMS sending completed with response code [{}] - [{}]", (Object)responseCode, (Object)this.applicationProperties.smsResponseMessageForCode(responseCode));
                return this.applicationProperties.smsErrorCodes().parallelStream().noneMatch(errorCode -> responseCode.startsWith((String)errorCode));
            }
            catch (IOException | UnsupportedOperationException e) {
                LOGGER.error("Error occurred while sending SMS [%s]", (Object)e.getMessage());
                return false;
            }
        }
        return false;
    }
}

