/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.messaging;

import javax.jms.Destination;
import javax.jms.MapMessage;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.common.service.MessageTemplateService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;

@Service
public class MessagingService {
    @Autowired
    private JmsTemplate jmsTemplate;
    @Autowired
    @Qualifier(value="emailQueue")
    private Destination emailQueue;
    @Autowired
    @Qualifier(value="smsQueue")
    private Destination smsQueue;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private ApplicationProperties applicationProperties;

    public void sendEmailAndSMS(User user, String subject, String templateName, Object ... messageValues) {
        this.sendEmail(user, subject, templateName, messageValues);
        this.sendSMS(user, templateName, messageValues);
    }

    public void sendEmail(User user, String subject, String templateName, Object ... messageValues) {
        this.sendEmail(user.getEmailId(), subject, this.messageTemplateService.realizeMessage(this.messageTemplateService.getByTemplateName(templateName), messageValues));
    }

    public void sendSMS(User user, String templateName, Object ... messageValues) {
        this.sendSMS(user.getMobileNumber(), this.messageTemplateService.realizeMessage(this.messageTemplateService.getByTemplateName(templateName), messageValues));
    }

    public void sendEmail(String email, String subject, String message) {
        if (this.applicationProperties.emailEnabled() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{email, subject, message})) {
            this.jmsTemplate.send(this.emailQueue, session -> {
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setString("email", email);
                mapMessage.setString("message", message);
                mapMessage.setString("subject", subject);
                return mapMessage;
            });
        }
    }

    public void sendSMS(String mobileNo, String message) {
        if (this.applicationProperties.smsEnabled() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobileNo, message})) {
            this.jmsTemplate.send(this.smsQueue, session -> {
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setString("mobile", "91" + mobileNo);
                mapMessage.setString("message", message);
                return mapMessage;
            });
        }
    }

    public void sendEmailWithAttachment(String email, String subject, String message, String fileType, String fileName, byte[] attachment) {
        if (this.applicationProperties.emailEnabled() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{email, subject, message})) {
            this.jmsTemplate.send(this.emailQueue, session -> {
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setString("email", email);
                mapMessage.setString("message", message);
                mapMessage.setString("subject", subject);
                mapMessage.setString("type", fileType);
                mapMessage.setString("name", fileName);
                mapMessage.setBytes("attachment", attachment);
                return mapMessage;
            });
        }
    }
}

