/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.redis;

import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.config.redis.EmbeddedRedisServer;
import org.egov.infra.config.redis.RedisServerConfigCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@Profile(value={"production"})
public class RedisServerConfiguration {
    @Bean
    @Conditional(value={RedisServerConfigCondition.class})
    public EmbeddedRedisServer redisServer() {
        return new EmbeddedRedisServer();
    }

    @Bean
    public JedisConnectionFactory redisConnectionFactory(ApplicationProperties applicationProperties) {
        if (applicationProperties.sentinelEnabled() && !applicationProperties.usingEmbeddedRedis()) {
            RedisSentinelConfiguration sentinelConfig = new RedisSentinelConfiguration();
            sentinelConfig.master(applicationProperties.sentinelMasterName());
            for (String host : applicationProperties.sentinelHosts()) {
                String[] hostConfig = host.split(":");
                sentinelConfig.sentinel(hostConfig[0].trim(), Integer.valueOf(hostConfig[1].trim()));
            }
            return new JedisConnectionFactory(sentinelConfig, this.redisPoolConfig());
        }
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(this.redisPoolConfig());
        jedisConnectionFactory.setHostName(applicationProperties.redisHost());
        jedisConnectionFactory.setPort(applicationProperties.redisPort());
        return jedisConnectionFactory;
    }

    @Bean
    public JedisPoolConfig redisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setTestOnBorrow(true);
        jedisPoolConfig.setMinEvictableIdleTimeMillis(60000L);
        jedisPoolConfig.setSoftMinEvictableIdleTimeMillis(1800000L);
        jedisPoolConfig.setNumTestsPerEvictionRun(-1);
        jedisPoolConfig.setTestOnReturn(false);
        jedisPoolConfig.setTestWhileIdle(true);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(30000L);
        return jedisPoolConfig;
    }

    @Bean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory cf) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(cf);
        return redisTemplate;
    }
}

