/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.multitenancy;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantSchemaConnectionProvider
implements MultiTenantConnectionProvider,
ServiceRegistryAwareService {
    private static final long serialVersionUID = -6022082859572861041L;
    private static final Logger LOG = LoggerFactory.getLogger(MultiTenantSchemaConnectionProvider.class);
    private DataSource dataSource;
    private String databaseType;

    public Connection getAnyConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseAnyConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public Connection getConnection(String tenantId) throws SQLException {
        Connection connection = this.getAnyConnection();
        try {
            if (this.databaseType.equals("POSTGRESQL")) {
                connection.createStatement().execute("SET SCHEMA '" + tenantId + "'");
            } else {
                connection.createStatement().execute("USE " + tenantId);
            }
        }
        catch (SQLException e) {
            LOG.error("Error occurred while switching tenant schema upon getting connection", (Throwable)e);
            throw new HibernateException("Could not alter JDBC connection to specified schema [" + tenantId + "]", (Throwable)e);
        }
        return connection;
    }

    public void releaseConnection(String tenantId, Connection connection) throws SQLException {
        try {
            if (this.databaseType.equals("POSTGRESQL")) {
                connection.createStatement().execute("SET SCHEMA '" + tenantId + "'");
            } else {
                connection.createStatement().execute("USE " + tenantId);
            }
        }
        catch (SQLException e) {
            LOG.warn("Error occurred while switching schema upon release connection", (Throwable)e);
        }
        this.releaseAnyConnection(connection);
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return MultiTenantConnectionProvider.class.equals((Object)unwrapType) || AbstractMultiTenantConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (this.isUnwrappableAs(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        Map settings = ((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings();
        this.dataSource = (DataSource)settings.get("hibernate.connection.datasource");
        this.databaseType = (String)settings.get("hibernate.database.type");
    }
}

