/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.multitenancy;

import java.sql.Connection;
import java.sql.SQLException;
import org.egov.infra.config.persistence.multitenancy.TenantDatasourceProvider;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;

public class MultiTenantDatabaseConnectionProvider
extends TenantDatasourceProvider
implements MultiTenantConnectionProvider {
    private static final long serialVersionUID = -4318080892788400229L;

    public Connection getAnyConnection() throws SQLException {
        return this.getAnyDataSource().getConnection();
    }

    public void releaseAnyConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public Connection getConnection(String tenantId) throws SQLException {
        return this.getTenantDataSource(tenantId).getConnection();
    }

    public void releaseConnection(String tenantId, Connection connection) throws SQLException {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return MultiTenantConnectionProvider.class.equals((Object)unwrapType) || AbstractMultiTenantConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (this.isUnwrappableAs(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }
}

