/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.egov.infra.config.properties.ApplicationProperties;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

@Configuration
public class DBMigrationConfiguration {
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    @DependsOn(value={"dataSource"})
    public Flyway flyway(DataSource dataSource) {
        this.tenants().parallelStream().forEach(schema -> {
            Flyway flyway = new Flyway();
            flyway.setBaselineOnMigrate(true);
            flyway.setOutOfOrder(true);
            if (this.applicationProperties.devMode()) {
                flyway.setLocations(new String[]{"classpath:/db/migration/main/", "classpath:/db/migration/sample/"});
            } else {
                flyway.setLocations(new String[]{"classpath:/db/migration/main/", "classpath:/db/migration/" + schema + "/"});
            }
            flyway.setDataSource(dataSource);
            flyway.setSchemas(new String[]{schema});
            flyway.migrate();
        });
        if (this.applicationProperties.statewideMigrationRequired()) {
            this.runStatewideMigration(dataSource);
        }
        return new Flyway();
    }

    private void runStatewideMigration(DataSource dataSource) {
        Flyway flyway = new Flyway();
        flyway.setBaselineOnMigrate(true);
        flyway.setOutOfOrder(true);
        flyway.setLocations(new String[]{"classpath:/db/migration/statewide/"});
        flyway.setDataSource(dataSource);
        flyway.setSchemas(new String[]{"public"});
        flyway.migrate();
    }

    @Bean(name={"tenants"}, autowire=Autowire.BY_NAME)
    public List<String> tenants() {
        ArrayList<String> tenants = new ArrayList<String>();
        this.environment.getPropertySources().iterator().forEachRemaining(propertySource -> {
            if (propertySource instanceof MapPropertySource) {
                ((Map)((MapPropertySource)propertySource).getSource()).forEach((key, value) -> {
                    if (key.startsWith("tenant.")) {
                        tenants.add(value.toString());
                    }
                });
            }
        });
        return tenants;
    }
}

