/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.jms.messaging;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.egov.infra.config.jms.messaging.errorhandler.MessagingErrorHandler;
import org.egov.infra.config.jms.messaging.listener.EmailQueueListener;
import org.egov.infra.config.jms.messaging.listener.SMSQueueListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

@Configuration
@DependsOn(value={"jmsConfiguration"})
public class MessagingConfiguration {
    @Bean(name={"smsQueue"})
    public JndiObjectFactoryBean smsQueue() throws IllegalArgumentException {
        JndiObjectFactoryBean smsQueue = new JndiObjectFactoryBean();
        smsQueue.setExpectedType(Destination.class);
        smsQueue.setResourceRef(true);
        smsQueue.setJndiName("java:/jms/queue/sms");
        return smsQueue;
    }

    @Bean(name={"emailQueue"})
    public JndiObjectFactoryBean emailQueue() throws IllegalArgumentException {
        JndiObjectFactoryBean emailQueue = new JndiObjectFactoryBean();
        emailQueue.setExpectedType(Destination.class);
        emailQueue.setResourceRef(true);
        emailQueue.setJndiName("java:/jms/queue/email");
        return emailQueue;
    }

    @Bean
    public DefaultJmsListenerContainerFactory jmsListenerContainerFactory(CachingConnectionFactory cachingConnectionFactory, PlatformTransactionManager transactionManager, JndiDestinationResolver jmsDestinationResolver) {
        DefaultJmsListenerContainerFactory listenerContainerFactory = new DefaultJmsListenerContainerFactory();
        listenerContainerFactory.setConnectionFactory((ConnectionFactory)cachingConnectionFactory);
        listenerContainerFactory.setTransactionManager(transactionManager);
        listenerContainerFactory.setErrorHandler((ErrorHandler)this.messagingErrorHandler());
        listenerContainerFactory.setDestinationResolver((DestinationResolver)jmsDestinationResolver);
        listenerContainerFactory.setConcurrency("10");
        return listenerContainerFactory;
    }

    @Bean
    public MessagingErrorHandler messagingErrorHandler() {
        return new MessagingErrorHandler();
    }

    @Bean
    public EmailQueueListener emailQueueListener() {
        return new EmailQueueListener();
    }

    @Bean
    public SMSQueueListener smsQueueListener() {
        return new SMSQueueListener();
    }
}

