/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.repository.AppConfigRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AppConfigService {
    private final AppConfigRepository appConfigRepository;

    @Autowired
    public AppConfigService(AppConfigRepository appConfigRepository) {
        this.appConfigRepository = appConfigRepository;
    }

    public AppConfig getAppConfigByModuleNameAndKeyName(String moduleName, String keyName) {
        return this.appConfigRepository.findByModule_NameAndKeyName(moduleName, keyName);
    }

    public AppConfig getAppConfigByKeyName(String keyName) {
        return this.appConfigRepository.findByKeyName(keyName);
    }

    public List<AppConfig> getAllAppConfigByModuleName(String moduleName) {
        return this.appConfigRepository.findByModule_Name(moduleName);
    }

    public Page<AppConfig> getAllAppConfig(String moduleName, Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"module.name"});
        return StringUtils.isBlank((CharSequence)moduleName) ? this.appConfigRepository.findAll((Pageable)pageable) : this.appConfigRepository.findByModule_Name(moduleName, (Pageable)pageable);
    }

    @Transactional
    public void createAppConfig(AppConfig appConfig) {
        this.appConfigRepository.save(appConfig);
    }

    @Transactional
    public void updateAppConfig(AppConfig appConfig) {
        appConfig.getConfValues().removeIf(AppConfigValues::isMarkedForRemoval);
        this.appConfigRepository.save(appConfig);
    }
}

