/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.repository;

import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.repository.ModuleRepositoryCustom;

public class ModuleRepositoryImpl
implements ModuleRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<Object[]> fetchModulesForRoles(Set<Role> roles) {
        StringBuilder sql = new StringBuilder().append("SELECT DISTINCT mod.name,mod.contextRoot,mod.displayName, mod.id, mod.ordernumber FROM eg_module mod,eg_action act ").append("WHERE act.id IN (SELECT DISTINCT actionid FROM eg_roleaction WHERE roleid IN (:roles)) ").append("AND mod.enabled=true AND act.enabled = true AND act.application=mod.id AND mod.parentmodule is null ORDER BY mod.ordernumber ASC");
        return this.entityManager.createNativeQuery(sql.toString()).setParameter("roles", roles).getResultList();
    }

    @Override
    public List<Object[]> fetchModulesByParentModuleId(Long parentId, Long userId) {
        StringBuilder sql = new StringBuilder().append("SELECT DISTINCT view_ram.module_id as id,view_ram.module_name as name,null as url,view_ram.typeflag as typeflag,view_ram.context_root as ctx_root,view_ram.order_number as ordernumber ").append("FROM VIEW_EG_MENULINK view_ram WHERE  view_ram.parent_id =:parentId and view_ram.typeflag='M' and view_ram.is_enabled=true ").append("AND EXISTS (SELECT action.id FROM eg_action action, eg_roleaction roleaction where action.parentmodule = view_ram.module_id ").append("AND action.enabled = true AND action.id = roleaction.actionid  AND roleaction.roleid IN (SELECT roleid FROM eg_userrole userrole ").append("WHERE userrole.userid = :userId) UNION (SELECT module.id FROM eg_module module WHERE module.parentmodule = view_ram.module_id AND module.enabled=true) ) ").append("UNION SELECT distinct view_ram.action_id as id,view_ram.action_name as name,view_ram.action_url as url,view_ram.typeflag as typeflag, ").append("view_ram.context_root as ctx_root,view_ram.order_number as ordernumber FROM VIEW_EG_MENULINK view_ram where   parent_id = :parentId and typeflag='A' ").append("AND view_ram.is_enabled=true and (view_ram.action_id in (select actionid from eg_roleaction ra  where ra.roleid in ").append("(select roleid from eg_userrole ur where ur.userid = :userId))) order by typeflag desc,ordernumber asc");
        return this.entityManager.createNativeQuery(sql.toString()).setParameter("parentId", (Object)parentId).setParameter("userId", (Object)userId).getResultList();
    }

    @Override
    public List<Object[]> fetchUserFavourateModules(Long userId) {
        StringBuilder sql = new StringBuilder().append("SELECT distinct view_ram.action_id,fav.name,fav.contextroot,view_ram.action_url ").append("FROM VIEW_EG_MENULINK view_ram, EG_FAVOURITES fav WHERE  fav.actionid = view_ram.action_id and fav.userid = :userId ").append("and view_ram.typeflag='A' and view_ram.is_enabled=true GROUP BY view_ram.action_id,fav.name,fav.contextroot,view_ram.action_url");
        return this.entityManager.createNativeQuery(sql.toString()).setParameter("userId", (Object)userId).getResultList();
    }
}

