/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.admin.master.entity.Action;
import org.hibernate.search.annotations.DocumentId;

@Entity
@Table(name="eg_module")
@SequenceGenerator(name="SEQ_EG_MODULE", sequenceName="SEQ_EG_MODULE", allocationSize=1)
@Cacheable
public class Module
implements Serializable {
    private static final long serialVersionUID = -632195454827894969L;
    public static final String SEQ_MODULE = "SEQ_EG_MODULE";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_MODULE", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String name;
    private boolean enabled;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parentModule")
    private Module parentModule;
    private String displayName;
    private Integer orderNumber;
    @OneToMany(mappedBy="parentModule", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<Action> actions = Collections.emptySet();
    private String contextRoot;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Module getParentModule() {
        return this.parentModule;
    }

    public void setParentModule(Module parentModule) {
        this.parentModule = parentModule;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer displayOrder) {
        this.orderNumber = displayOrder;
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public void setActions(Set<Action> actions) {
        this.actions = actions;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

