/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.google.gson.annotations.Expose;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.search.domain.Searchable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Unique(id="id", tableName="eg_department", columnName={"name", "code"}, fields={"name", "code"}, enableDfltMsg=true)
@Table(name="eg_department")
@Searchable
@SequenceGenerator(name="SEQ_EG_DEPARTMENT", sequenceName="SEQ_EG_DEPARTMENT", allocationSize=1)
public class Department
extends AbstractAuditable {
    private static final long serialVersionUID = 7630238192598939863L;
    public static final String SEQ_DEPARTMENT = "SEQ_EG_DEPARTMENT";
    @Expose
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_DEPARTMENT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(min=1, max=128)
    @Searchable(name="name")
    @SafeHtml
    private String name;
    @NotBlank
    @Length(min=1, max=128)
    @SafeHtml
    private String code;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Department other = (Department)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

