/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.search.domain.Searchable;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eg_appconfig")
@SequenceGenerator(name="SEQ_EG_APPCONFIG", sequenceName="SEQ_EG_APPCONFIG", allocationSize=1)
@CompositeUnique(fields={"keyName", "module"}, enableDfltMsg=true)
@Searchable
@NamedEntityGraph(name="AppConfig.values", attributeNodes={@NamedAttributeNode(value="confValues")})
public class AppConfig
extends AbstractAuditable {
    private static final long serialVersionUID = 8904645810221559541L;
    public static final String SEQ_APPCONFIG = "SEQ_EG_APPCONFIG";
    public static final String FETCH_WITH_VALUES = "AppConfig.values";
    @Expose
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_APPCONFIG", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    @Length(max=250)
    @Column(name="key_name", updatable=false)
    @Searchable
    private String keyName;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="module", nullable=false, updatable=false)
    @NotNull
    @Searchable
    private Module module;
    @NotBlank
    @SafeHtml
    @Length(max=250)
    @Searchable
    @Column(name="description")
    private String description;
    @Valid
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="config", orphanRemoval=true)
    @Fetch(value=FetchMode.JOIN)
    private List<AppConfigValues> confValues = new ArrayList<AppConfigValues>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AppConfigValues> getConfValues() {
        this.confValues.forEach(configValue -> configValue.setConfig(this));
        return this.confValues;
    }

    public void setConfValues(List<AppConfigValues> confValues) {
        this.confValues = confValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppConfig)) {
            return false;
        }
        AppConfig appConfig = (AppConfig)o;
        return Objects.equals(this.keyName, appConfig.keyName) && Objects.equals(this.module, appConfig.module);
    }

    public int hashCode() {
        return Objects.hash(this.keyName, this.module);
    }
}

