/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.Arrays;
import java.util.List;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.repository.HierarchyTypeRepository;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.aop.aspectj.annotation.AspectJProxyFactory;

public class HierarchyTypeServiceTest {
    @Mock
    private HierarchyTypeRepository hierarchyTypeRepository;
    private HierarchyTypeService hierarchyTypeService;
    private HierarchyType expectedHierarchyType;
    private HierarchyType expectedHierarchyType1;
    private HierarchyType expectedHierarchyType2;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.hierarchyTypeService = new HierarchyTypeService(this.hierarchyTypeRepository);
        AspectJProxyFactory factory = new AspectJProxyFactory((Object)this.hierarchyTypeService);
        this.hierarchyTypeService = (HierarchyTypeService)factory.getProxy();
        this.expectedHierarchyType = new HierarchyType();
        this.expectedHierarchyType.setName("Test");
        this.expectedHierarchyType.setCode("TEST");
        this.expectedHierarchyType1 = new HierarchyType();
        this.expectedHierarchyType1.setName("Administration");
        this.expectedHierarchyType1.setCode("ADMIN");
        this.expectedHierarchyType2 = new HierarchyType();
        this.expectedHierarchyType2.setName("Location");
        this.expectedHierarchyType2.setCode("LOCATION");
    }

    @Test
    public void testCreateHierarchyType() {
        HierarchyType hierarchyType = new HierarchyType();
        hierarchyType.setName("Test One");
        hierarchyType.setCode("TEST_ONE");
        this.hierarchyTypeService.createHierarchyType(hierarchyType);
        ((HierarchyTypeRepository)Mockito.verify((Object)this.hierarchyTypeRepository)).save((Object)hierarchyType);
    }

    @Test
    public void testGetHierarchyTypeByName() {
        Mockito.when((Object)this.hierarchyTypeService.getHierarchyTypeByName("Test")).thenReturn((Object)this.expectedHierarchyType);
        HierarchyType hierarchyType = this.hierarchyTypeService.getHierarchyTypeByName("Test");
        Assert.assertTrue((boolean)hierarchyType.getName().equalsIgnoreCase(this.expectedHierarchyType.getName()));
    }

    @Test
    public void testGetAllHierarchyTypes() {
        Mockito.when((Object)this.hierarchyTypeService.getAllHierarchyTypes()).thenReturn(Arrays.asList(this.expectedHierarchyType1, this.expectedHierarchyType2));
        List hierarchyTypes = this.hierarchyTypeService.getAllHierarchyTypes();
        Assert.assertEquals((long)2L, (long)hierarchyTypes.size());
        ((HierarchyTypeRepository)Mockito.verify((Object)this.hierarchyTypeRepository)).findAll();
    }
}

