/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.security.spring.event.actions;

import java.util.Date;
import java.util.HashMap;
import org.egov.infra.config.security.authentication.SecureUser;
import org.egov.infra.security.audit.entity.SystemAudit;
import org.egov.infra.security.audit.service.LoginAttemptService;
import org.egov.infra.security.audit.service.SystemAuditService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infstr.security.spring.event.actions.ApplicationSecurityEventAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationSuccessEventAction
implements ApplicationSecurityEventAction<InteractiveAuthenticationSuccessEvent> {
    @Autowired
    private SystemAuditService systemAuditService;
    @Autowired
    private LoginAttemptService loginAttemptService;
    @Autowired
    private SecurityUtils securityUtils;

    @Override
    public void doAction(InteractiveAuthenticationSuccessEvent authorizedEvent) {
        this.auditLoginDetails(authorizedEvent);
        this.resetFailedLoginAttempt(authorizedEvent);
    }

    private void auditLoginDetails(InteractiveAuthenticationSuccessEvent authorizedEvent) {
        HashMap creds = (HashMap)authorizedEvent.getAuthentication().getCredentials();
        SystemAudit systemAudit = new SystemAudit();
        systemAudit.setLoginTime(new Date(authorizedEvent.getTimestamp()));
        systemAudit.setUser(this.securityUtils.getCurrentUser());
        systemAudit.setIpAddress((String)creds.get("ipAddress"));
        systemAudit.setUserAgentInfo((String)creds.get("userAgentInfo"));
        this.systemAuditService.createOrUpdateSystemAudit(systemAudit);
        String loginLogID = systemAudit.getId().toString();
        creds.put("loginLogId", loginLogID);
    }

    private void resetFailedLoginAttempt(InteractiveAuthenticationSuccessEvent authorizedEvent) {
        this.loginAttemptService.resetFailedAttempt(((SecureUser)authorizedEvent.getAuthentication().getPrincipal()).getUsername());
    }
}

