/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.search;

import java.math.BigInteger;
import java.util.List;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.SQLQuery;

public class SearchQuerySQL
implements SearchQuery {
    private final String searchQuery;
    private final String countQuery;
    private Object[] params = new Object[0];

    public SearchQuerySQL(String searchQuery, String countQuery, List<Object> params) {
        this.searchQuery = searchQuery;
        this.countQuery = countQuery;
        if (params != null) {
            this.params = params.toArray();
        }
    }

    @Override
    public int getCount(PersistenceService persistenceService) {
        Query q = this.getSQLQueryWithParams(persistenceService, this.countQuery);
        return ((BigInteger)q.uniqueResult()).intValue();
    }

    @Override
    public Page getPage(PersistenceService persistenceService, int pageNum, int pageSize) {
        Query q = this.getSQLQueryWithParams(persistenceService, this.searchQuery);
        return new Page(q, (Integer)pageNum, (Integer)pageSize);
    }

    private Query getSQLQueryWithParams(PersistenceService persistenceService, String query) {
        SQLQuery q = persistenceService.getSession().createSQLQuery(query);
        if (this.params != null && this.params.length > 0) {
            for (int index = 0; index < this.params.length; ++index) {
                q.setParameter(index, this.params[index]);
            }
        }
        return q;
    }
}

