/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.displaytag.export;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.BinaryExportView;
import org.displaytag.export.PdfView;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.displaytag.export.MyHtmlParser;

public class EGovPdfView
implements BinaryExportView {
    private boolean header;
    private TableModel model;
    private boolean exportFull;
    private Font smallFont;
    private boolean decorated;
    private Table tablePDF;
    private Paragraph tableCaption;

    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
        this.exportFull = exportFullList;
        this.header = includeHeader;
        this.decorated = decorateValues;
    }

    public String getMimeType() {
        return "application/pdf";
    }

    protected void initTable() throws BadElementException {
        this.tablePDF = new Table(this.model.getNumberOfColumns());
        this.tablePDF.setCellsFitPage(true);
        this.tablePDF.setWidth(100.0f);
        this.tablePDF.setPadding(2.0f);
        this.tablePDF.setSpacing(0.0f);
        this.smallFont = FontFactory.getFont((String)"Helvetica", (float)7.0f, (int)0, (Color)new Color(0, 0, 0));
    }

    protected void generatePDFTable() throws JspException, BadElementException {
        if (this.header) {
            this.generateCaption();
            this.generateHeaders();
        }
        this.tablePDF.endHeaders();
        this.generateRows();
    }

    protected void generateRows() throws JspException, BadElementException {
        RowIterator rowIterator = this.model.getRowIterator(this.exportFull);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            ColumnIterator columnIterator = row.getColumnIterator(this.model.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                Object value = column.getValue(this.decorated);
                Cell cell = this.getCell(ObjectUtils.toString((Object)value));
                if (value instanceof BigDecimal) {
                    cell.setHorizontalAlignment(2);
                }
                this.tablePDF.addCell(cell);
            }
        }
    }

    protected void generateHeaders() throws BadElementException {
        for (HeaderCell headerCell : this.model.getHeaderCellList()) {
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            Cell hdrCell = this.getCell(columnHeader);
            hdrCell.setGrayFill(0.9f);
            hdrCell.setHeader(true);
            this.tablePDF.addCell(hdrCell);
        }
    }

    protected void generateCaption() throws BadElementException {
        Paragraph caption = new Paragraph(new Chunk(this.removeHtmlTagsAndSpaces(this.model.getCaption()), this.getCaptionFont()));
        caption.setAlignment(this.getCaptionHorizontalAlignment());
        this.tableCaption = caption;
    }

    public void doExport(OutputStream out) throws JspException {
        try {
            this.initTable();
            Document document = new Document(PageSize.A4.rotate(), 60.0f, 60.0f, 40.0f, 40.0f);
            document.addCreationDate();
            HeaderFooter footer = new HeaderFooter(new Phrase("caption", this.smallFont), true);
            footer.setBorder(0);
            footer.setAlignment(1);
            PdfWriter.getInstance((Document)document, (OutputStream)out).setPageEvent((PdfPageEvent)new PageNumber());
            this.generatePDFTable();
            document.open();
            document.add((Element)this.tableCaption);
            document.add((Element)this.tablePDF);
            document.close();
        }
        catch (Exception e) {
            throw new PdfGenerationException(e);
        }
    }

    protected int getCaptionHorizontalAlignment() {
        return 0;
    }

    private Cell getCell(String value) throws BadElementException {
        value = this.removeHtmlTagsAndSpaces(value);
        Cell cell = new Cell((Element)new Chunk(StringUtils.trimToEmpty((String)value), this.smallFont));
        cell.setVerticalAlignment(4);
        cell.setLeading(8.0f);
        return cell;
    }

    private String removeHtmlTagsAndSpaces(String strValue) {
        String returnValue = null;
        if (strValue != null) {
            StringReader strReader = new StringReader(strValue);
            MyHtmlParser parser = new MyHtmlParser();
            returnValue = parser.parseMyHtml(strReader, true);
        }
        return returnValue;
    }

    protected Font getCaptionFont() {
        return FontFactory.getFont((String)"Helvetica", (float)17.0f, (int)1, (Color)new Color(0, 0, 0));
    }

    private static class PageNumber
    extends PdfPageEventHelper {
        private PageNumber() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
            PdfPTable table = new PdfPTable(2);
            PdfTemplate tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            BaseFont helv = null;
            try {
                helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            }
            catch (DocumentException e) {
                throw new ApplicationRuntimeException("Exception occured -----> " + e.getMessage());
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception occured -----> " + e.getMessage());
            }
            PdfContentByte cb = writer.getDirectContent();
            cb.saveState();
            cb.restoreState();
            table.setTotalWidth(document.right() - document.left());
            String text = "Page " + writer.getPageNumber();
            float textSize = helv.getWidthPoint(text, 12.0f);
            float textBase = document.bottom() - 20.0f;
            cb.beginText();
            cb.setFontAndSize(helv, 12.0f);
            float adjust = helv.getWidthPoint("0", 12.0f);
            cb.setTextMatrix(document.right() - textSize - adjust, textBase);
            cb.showText(text);
            cb.endText();
            cb.addTemplate(tpl, document.right() - adjust, textBase);
            cb.saveState();
            cb.restoreState();
        }
    }

    static class PdfGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public PdfGenerationException(Throwable cause) {
            super(PdfView.class, Messages.getString((String)"PdfView.errorexporting"), cause);
        }

        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }
}

