/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.io.Serializable;
import java.sql.SQLException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplicationNumberGenerator {
    private static final String APP_NUMBER_SEQ_PREFIX = "SEQ_APPLICATION_NUMBER%s";
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;

    @Transactional
    public String generate() {
        try {
            Serializable sequenceNumber;
            String currentYear = DateUtils.currentDateToYearFormat();
            String sequenceName = String.format(APP_NUMBER_SEQ_PREFIX, currentYear);
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%05d-%s-%s", sequenceNumber, currentYear, StringUtils.upperCase((String)RandomStringUtils.randomAlphabetic((int)2)));
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Application Number", e);
        }
    }
}

