/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.search.elastic.service;

import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.infra.search.elastic.entity.CollectionIndex;
import org.egov.infra.search.elastic.repository.CollectionIndexRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CollectionIndexService {
    private final CollectionIndexRepository collectionIndexRepository;
    @Autowired
    private CityService cityService;

    @Autowired
    public CollectionIndexService(CollectionIndexRepository collectionIndexRepository) {
        this.collectionIndexRepository = collectionIndexRepository;
    }

    @Transactional
    @Indexing(name=Index.COLLECTION, type=IndexType.COLLECTION_BIFURCATION)
    public CollectionIndex persistCollectionIndex(CollectionIndex collectionIndex) {
        return (CollectionIndex)this.collectionIndexRepository.save(collectionIndex);
    }

    @Transactional
    @Indexing(name=Index.COLLECTION, type=IndexType.COLLECTION_BIFURCATION)
    public CollectionIndex pushCollectionIndex(CollectionIndex collectionIndex) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        collectionIndex.setCityName(cityWebsite.getName());
        if (cityWebsite.getDistrictName() != null) {
            collectionIndex.setDistrictName(cityWebsite.getDistrictName());
        }
        if (cityWebsite.getRegionName() != null) {
            collectionIndex.setRegionName(cityWebsite.getRegionName());
        }
        if (cityWebsite.getGrade() != null) {
            collectionIndex.setCityGrade(cityWebsite.getGrade());
        }
        if (cityWebsite.getCode() != null) {
            collectionIndex.setCityCode(cityWebsite.getCode());
        }
        this.collectionIndexRepository.save(collectionIndex);
        return collectionIndex;
    }
}

