/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.search.elastic.entity;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.search.domain.Searchable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EG_COLLECTIONINDEX")
@SequenceGenerator(name="SEQ_EG_COLLECTIONINDEX", sequenceName="SEQ_EG_COLLECTIONINDEX", allocationSize=1)
public class CollectionIndex
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_COLLECTIONINDEX = "SEQ_EG_COLLECTIONINDEX";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_COLLECTIONINDEX", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Searchable(name="receiptdate")
    private Date receiptDate;
    @NotNull
    @Length(max=50)
    @Searchable(name="receiptnumber", group=Searchable.Group.CLAUSES)
    private String receiptNumber;
    @NotNull
    @Length(max=100)
    @Searchable(name="billingservice", group=Searchable.Group.CLAUSES)
    private String billingService;
    @NotNull
    @Length(max=50)
    @Searchable(name="paymentmode", group=Searchable.Group.CLAUSES)
    private String paymentMode;
    @Searchable(name="arrearamount", group=Searchable.Group.SEARCHABLE)
    private BigDecimal arrearAmount;
    @Searchable(name="penaltyamount", group=Searchable.Group.SEARCHABLE)
    private BigDecimal penaltyAmount;
    @Searchable(name="currentamount", group=Searchable.Group.SEARCHABLE)
    private BigDecimal currentAmount;
    @NotNull
    @Searchable(name="totalamount", group=Searchable.Group.SEARCHABLE)
    private BigDecimal totalAmount;
    @Searchable(name="advanceamount", group=Searchable.Group.SEARCHABLE)
    private BigDecimal advanceAmount;
    @NotNull
    @Length(max=50)
    @Searchable(name="channel", group=Searchable.Group.CLAUSES)
    private String channel;
    @Length(max=100)
    @Searchable(name="paymentgateway", group=Searchable.Group.CLAUSES)
    private String paymentGateway;
    @Searchable(name="billnumber", group=Searchable.Group.CLAUSES)
    private String billNumber;
    @Length(max=50)
    @Searchable(name="consumercode", group=Searchable.Group.COMMON)
    private String consumerCode;
    @NotNull
    @Length(max=250)
    @Searchable(name="cityname", group=Searchable.Group.CLAUSES)
    private String cityName;
    @Length(max=250)
    @Searchable(name="districtname", group=Searchable.Group.CLAUSES)
    private String districtName;
    @Length(max=250)
    @Searchable(name="regionname", group=Searchable.Group.CLAUSES)
    private String regionName;
    @NotNull
    @Length(max=50)
    @Searchable(name="status", group=Searchable.Group.CLAUSES)
    private String status;
    @Searchable(name="latepaymentcharges", group=Searchable.Group.SEARCHABLE)
    private BigDecimal latePaymentCharges;
    @Searchable(name="arrearcess", group=Searchable.Group.SEARCHABLE)
    private BigDecimal arrearCess;
    @Searchable(name="currentcess", group=Searchable.Group.SEARCHABLE)
    private BigDecimal currentCess;
    @Length(max=50)
    @Searchable(name="installmentfrom", group=Searchable.Group.SEARCHABLE)
    private String installmentFrom;
    @Length(max=50)
    @Searchable(name="installmentto", group=Searchable.Group.SEARCHABLE)
    private String installmentTo;
    @Length(max=256)
    @Searchable(name="consumername", group=Searchable.Group.SEARCHABLE)
    private String consumerName;
    @Searchable(name="reductionamount", group=Searchable.Group.SEARCHABLE)
    private BigDecimal reductionAmount;
    @Length(max=50)
    @Searchable(name="citygrade", group=Searchable.Group.CLAUSES)
    private String cityGrade;
    @Length(max=10)
    @Searchable(name="citycode", group=Searchable.Group.CLAUSES)
    private String cityCode;
    @Length(max=100)
    @Searchable(name="receiptcreator", group=Searchable.Group.CLAUSES)
    private String receiptCreator;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Date getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getBillingService() {
        return this.billingService;
    }

    public void setBillingService(String billingService) {
        this.billingService = billingService;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public BigDecimal getAdvanceAmount() {
        return this.advanceAmount;
    }

    public void setAdvanceAmount(BigDecimal advanceAmount) {
        this.advanceAmount = advanceAmount;
    }

    public BigDecimal getArrearAmount() {
        return this.arrearAmount;
    }

    public void setArrearAmount(BigDecimal arrearAmount) {
        this.arrearAmount = arrearAmount;
    }

    public BigDecimal getPenaltyAmount() {
        return this.penaltyAmount;
    }

    public void setPenaltyAmount(BigDecimal penaltyAmount) {
        this.penaltyAmount = penaltyAmount;
    }

    public BigDecimal getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(BigDecimal currentAmount) {
        this.currentAmount = currentAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPaymentGateway() {
        return this.paymentGateway;
    }

    public void setPaymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getLatePaymentCharges() {
        return this.latePaymentCharges;
    }

    public void setLatePaymentCharges(BigDecimal latePaymentCharges) {
        this.latePaymentCharges = latePaymentCharges;
    }

    public BigDecimal getArrearCess() {
        return this.arrearCess;
    }

    public void setArrearCess(BigDecimal arrearCess) {
        this.arrearCess = arrearCess;
    }

    public BigDecimal getCurrentCess() {
        return this.currentCess;
    }

    public void setCurrentCess(BigDecimal currentCess) {
        this.currentCess = currentCess;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String getInstallmentFrom() {
        return this.installmentFrom;
    }

    public void setInstallmentFrom(String installmentFrom) {
        this.installmentFrom = installmentFrom;
    }

    public String getInstallmentTo() {
        return this.installmentTo;
    }

    public void setInstallmentTo(String installmentTo) {
        this.installmentTo = installmentTo;
    }

    @Override
    public String getIndexId() {
        return ApplicationThreadLocals.getCityCode() + "-" + this.getReceiptNumber();
    }

    public BigDecimal getReductionAmount() {
        return this.reductionAmount;
    }

    public void setReductionAmount(BigDecimal reductionAmount) {
        this.reductionAmount = reductionAmount;
    }

    public String getCityGrade() {
        return this.cityGrade;
    }

    public void setCityGrade(String cityGrade) {
        this.cityGrade = cityGrade;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getReceiptCreator() {
        return this.receiptCreator;
    }

    public void setReceiptCreator(String receiptCreator) {
        this.receiptCreator = receiptCreator;
    }
}

