/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.search.elastic.entity;

import java.util.Date;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.search.elastic.entity.ApplicationIndex;
import org.egov.infra.search.elastic.entity.enums.ApprovalStatus;
import org.egov.infra.search.elastic.entity.enums.ClosureStatus;

public class ApplicationIndexBuilder {
    private final ApplicationIndex applicationIndex = new ApplicationIndex();

    public ApplicationIndexBuilder(String moduleName, String applicationNumber, Date applicationDate, String applicationType, String applicantName, String status, String url, String applicantAddress, String ownername, String channel) {
        this.applicationIndex.setModuleName(moduleName);
        this.applicationIndex.setApplicationNumber(applicationNumber);
        this.applicationIndex.setApplicationDate(applicationDate);
        this.applicationIndex.setApplicationType(moduleName.concat("-".concat(applicationType)));
        this.applicationIndex.setApplicantName(applicantName);
        this.applicationIndex.setStatus(status);
        this.applicationIndex.setUrl(url);
        this.applicationIndex.setApplicantAddress(applicantAddress);
        this.applicationIndex.setOwnername(ownername);
        this.applicationIndex.setChannel(channel);
    }

    public ApplicationIndexBuilder applicationAddress(String applicantAddress) {
        this.applicationIndex.setApplicantAddress(applicantAddress);
        return this;
    }

    public ApplicationIndexBuilder disposalDate(Date disposalDate) {
        this.applicationIndex.setDisposalDate(disposalDate);
        return this;
    }

    public ApplicationIndexBuilder consumerCode(String consumerCode) {
        this.applicationIndex.setConsumerCode(consumerCode);
        return this;
    }

    public ApplicationIndexBuilder mobileNumber(String mobileNumber) {
        this.applicationIndex.setMobileNumber(mobileNumber);
        return this;
    }

    public ApplicationIndexBuilder aadharNumber(String aadharNumber) {
        this.applicationIndex.setAadharNumber(aadharNumber);
        return this;
    }

    public ApplicationIndexBuilder elapsedDays(Integer numberOfDays) {
        this.applicationIndex.setElapsedDays(numberOfDays);
        return this;
    }

    public ApplicationIndexBuilder closed(ClosureStatus closed) {
        this.applicationIndex.setClosed(closed);
        return this;
    }

    public ApplicationIndexBuilder approved(ApprovalStatus approved) {
        this.applicationIndex.setApproved(approved);
        return this;
    }

    public ApplicationIndex build() throws ApplicationRuntimeException {
        this.validate();
        return this.applicationIndex;
    }

    private void validate() throws ApplicationRuntimeException {
        if (this.applicationIndex.getModuleName() == null) {
            throw new ApplicationRuntimeException("Module Name is mandatory");
        }
        if (this.applicationIndex.getApplicationNumber() == null) {
            throw new ApplicationRuntimeException("Application Number is mandatory");
        }
        if (this.applicationIndex.getApplicationDate() == null) {
            throw new ApplicationRuntimeException("Application Date is mandatory");
        }
        if (this.applicationIndex.getApplicationType() == null) {
            throw new ApplicationRuntimeException("Application Type is mandatory");
        }
        if (this.applicationIndex.getApplicantName() == null) {
            throw new ApplicationRuntimeException("Applicant Name is mandatory");
        }
        if (this.applicationIndex.getStatus() == null) {
            throw new ApplicationRuntimeException("Application Status is mandatory");
        }
        if (this.applicationIndex.getUrl() == null) {
            throw new ApplicationRuntimeException("URL is mandatory");
        }
        if (this.applicationIndex.getChannel() == null) {
            throw new ApplicationRuntimeException("Channel is mandatory");
        }
    }
}

