/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.search.elastic.entity;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.search.elastic.entity.enums.ApprovalStatus;
import org.egov.infra.search.elastic.entity.enums.ClosureStatus;
import org.egov.search.domain.Searchable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EG_APPLICATIONINDEX")
@SequenceGenerator(name="SEQ_EG_APPLICATIONINDEX", sequenceName="SEQ_EG_APPLICATIONINDEX", allocationSize=1)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="version")
public class ApplicationIndex
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_APPLICATIONINDEX = "SEQ_EG_APPLICATIONINDEX";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_APPLICATIONINDEX", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Length(max=50)
    @Searchable(name="modulename", group=Searchable.Group.CLAUSES)
    private String moduleName;
    @NotNull
    @Length(max=50)
    @Searchable(name="applicationnumber")
    private String applicationNumber;
    @NotNull
    @Searchable(name="applicationdate")
    private Date applicationDate;
    @NotNull
    @Length(max=150)
    @Searchable(name="applicationtype", group=Searchable.Group.CLAUSES)
    private String applicationType;
    @NotNull
    @Length(max=100)
    @Searchable(name="applicantname")
    private String applicantName;
    @Length(max=250)
    @Searchable
    private String applicantAddress;
    private Date disposalDate;
    @NotNull
    @Length(max=50)
    @Searchable(group=Searchable.Group.CLAUSES)
    private String status;
    @NotNull
    @Length(max=250)
    @Searchable
    private String url;
    @Length(max=50)
    @Searchable(name="consumercode")
    private String consumerCode;
    @Length(min=10, max=50)
    @Searchable(name="mobilenumber")
    private String mobileNumber;
    @Searchable(name="ownername", group=Searchable.Group.CLAUSES)
    private String ownername;
    @Length(min=10, max=50)
    @Searchable(name="aadharnumber", group=Searchable.Group.SEARCHABLE)
    private String aadharNumber;
    @Searchable(name="elapseddays", group=Searchable.Group.CLAUSES)
    private Integer elapsedDays;
    @Length(max=50)
    @Enumerated(value=EnumType.STRING)
    @Searchable(name="closed", group=Searchable.Group.CLAUSES)
    private ClosureStatus closed;
    @Length(max=50)
    @Enumerated(value=EnumType.STRING)
    @Searchable(name="approved", group=Searchable.Group.CLAUSES)
    private ApprovalStatus approved;
    @Length(max=50)
    @Searchable(name="channel", group=Searchable.Group.CLAUSES)
    private String channel;
    @Transient
    @Searchable(name="citycode", group=Searchable.Group.CLAUSES)
    private String cityCode;
    @NotNull
    @Length(max=250)
    @Searchable(name="cityname", group=Searchable.Group.CLAUSES)
    private String cityName;
    @Transient
    @Searchable(name="citygrade", group=Searchable.Group.CLAUSES)
    private String cityGrade;
    @Length(max=250)
    @Searchable(name="districtname", group=Searchable.Group.CLAUSES)
    private String districtName;
    @Transient
    @Searchable(name="regionname", group=Searchable.Group.CLAUSES)
    private String regionName;
    @Transient
    @Searchable(name="isclosed", group=Searchable.Group.SEARCHABLE)
    private Integer isClosed;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getApplicantAddress() {
        return this.applicantAddress;
    }

    public void setApplicantAddress(String applicantAddress) {
        this.applicantAddress = applicantAddress;
    }

    public Date getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getOwnername() {
        return this.ownername;
    }

    public void setOwnername(String ownername) {
        this.ownername = ownername;
    }

    public String getAadharNumber() {
        return this.aadharNumber;
    }

    public void setAadharNumber(String aadharNumber) {
        this.aadharNumber = aadharNumber;
    }

    public Integer getElapsedDays() {
        return this.elapsedDays;
    }

    public void setElapsedDays(Integer elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    public ClosureStatus getClosed() {
        return this.closed;
    }

    public void setClosed(ClosureStatus closed) {
        this.closed = closed;
        this.isClosed = this.closed.toString().equals(ClosureStatus.YES.toString()) ? Integer.valueOf(0) : Integer.valueOf(1);
    }

    public ApprovalStatus getApproved() {
        return this.approved;
    }

    public void setApproved(ApprovalStatus approved) {
        this.approved = approved;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Integer getIsClosed() {
        return this.isClosed;
    }

    public String getCityGrade() {
        return this.cityGrade;
    }

    public void setCityGrade(String cityGrade) {
        this.cityGrade = cityGrade;
    }
}

