/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.service;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public abstract class HibernateRepository<T> {
    @PersistenceContext
    protected EntityManager entityManager;
    protected Class<T> entityType;

    protected HibernateRepository(Class<T> entityType) {
        this.entityType = entityType;
    }

    public T save(T entity) {
        this.getCurrentSession().saveOrUpdate(entity);
        this.getCurrentSession().flush();
        return entity;
    }

    public void evict(T entity) {
        this.getCurrentSession().evict(entity);
    }

    public T create(T entity) {
        this.getCurrentSession().save(entity);
        this.getCurrentSession().flush();
        return entity;
    }

    public T merge(T entity) {
        Object mergedEntity = this.getCurrentSession().merge(entity);
        this.getCurrentSession().flush();
        return (T)mergedEntity;
    }

    public T get(Long id) {
        return (T)this.getCurrentSession().get(this.entityType, (Serializable)id);
    }

    public T load(Long id) {
        return (T)this.getCurrentSession().load(this.entityType, (Serializable)id);
    }

    public Criteria createCriteria(Class<T> clazz) {
        return this.getCurrentSession().createCriteria(clazz);
    }

    public T findByField(String field, String value) {
        Criteria criteria = this.createCriteria(this.entityType);
        return (T)criteria.add((Criterion)Restrictions.eq((String)field, (Object)value)).uniqueResult();
    }

    public List<T> findAll() {
        return this.getCurrentSession().createQuery(String.format("from %s", this.entityType.getSimpleName())).list();
    }

    public List<T> findAllLike(String fieldName, String value) {
        return this.createCriteria(this.entityType).add(Restrictions.ilike((String)fieldName, (String)value, (MatchMode)MatchMode.ANYWHERE)).list();
    }

    public Query query(String queryName) {
        return this.getCurrentSession().getNamedQuery(queryName);
    }

    protected void flushAndClear() {
        Session currentSession = this.getCurrentSession();
        currentSession.flush();
        currentSession.clear();
    }

    protected Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }
}

