/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.entity;

import java.io.Serializable;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.search.elastic.Indexable;

@MappedSuperclass
public abstract class AbstractPersistable<PK extends Serializable>
implements Serializable,
Indexable {
    private static final long serialVersionUID = 7094572260034458544L;
    @Version
    private Long version;

    protected abstract void setId(PK var1);

    public abstract PK getId();

    public Long getVersion() {
        return this.version;
    }

    public boolean isNew() {
        return null == this.getId();
    }

    public String toString() {
        return String.format("Entity of type %s with id: %s", this.getClass().getName(), this.getId());
    }

    @Override
    public String getIndexId() {
        return ApplicationThreadLocals.getCityCode() + "-" + this.getId().toString();
    }
}

