/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.egov.infra.config.properties.ApplicationProperties;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

@Configuration
public class DBMigrationConfiguration {
    public static final String MAIN_MIGRATION_FILE_PATH = "classpath:/db/migration/main/";
    public static final String SAMPLE_MIGRATION_FILE_PATH = "classpath:/db/migration/sample/";
    public static final String TENANT_MIGRATION_FILE_PATH = "classpath:/db/migration/%s/";
    public static final String STATEWIDE_MIGRATION_FILE_PATH = "classpath:/db/migration/statewide/";
    public static final String PUBLIC_SCHEMA = "public";
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    @DependsOn(value={"dataSource"})
    public Flyway flyway(DataSource dataSource, @Qualifier(value="cities") List<String> cities) {
        if (this.applicationProperties.isMasterServer()) {
            boolean devMode = this.applicationProperties.devMode();
            cities.parallelStream().forEach(schema -> {
                if (devMode) {
                    this.migrateDatabase((String)schema, dataSource, MAIN_MIGRATION_FILE_PATH, SAMPLE_MIGRATION_FILE_PATH, String.format(TENANT_MIGRATION_FILE_PATH, schema));
                } else {
                    this.migrateDatabase((String)schema, dataSource, MAIN_MIGRATION_FILE_PATH, String.format(TENANT_MIGRATION_FILE_PATH, schema));
                }
            });
            if (this.applicationProperties.statewideMigrationRequired() && !devMode) {
                this.migrateDatabase(PUBLIC_SCHEMA, dataSource, MAIN_MIGRATION_FILE_PATH, STATEWIDE_MIGRATION_FILE_PATH, String.format(TENANT_MIGRATION_FILE_PATH, PUBLIC_SCHEMA));
            } else if (!devMode) {
                this.migrateDatabase(PUBLIC_SCHEMA, dataSource, MAIN_MIGRATION_FILE_PATH, String.format(TENANT_MIGRATION_FILE_PATH, PUBLIC_SCHEMA));
            }
        }
        return new Flyway();
    }

    private void migrateDatabase(String schema, DataSource dataSource, String ... locations) {
        Flyway flyway = new Flyway();
        flyway.setBaselineOnMigrate(true);
        flyway.setValidateOnMigrate(this.applicationProperties.flywayValidateonMigrate());
        flyway.setOutOfOrder(true);
        flyway.setLocations(locations);
        flyway.setDataSource(dataSource);
        flyway.setSchemas(new String[]{schema});
        flyway.migrate();
    }

    @Bean(name={"tenants"}, autowire=Autowire.BY_NAME)
    public List<String> tenants() {
        ArrayList<String> tenants = new ArrayList<String>();
        this.environment.getPropertySources().iterator().forEachRemaining(propertySource -> {
            if (propertySource instanceof MapPropertySource) {
                ((Map)((MapPropertySource)propertySource).getSource()).forEach((key, value) -> {
                    if (key.startsWith("tenant.")) {
                        tenants.add(value.toString());
                    }
                });
            }
        });
        return tenants;
    }
}

